#!/usr/bin/env bash

CONFIG=$1 
CHECKPOINT=$2
GPUS=$3

export HIP_VISIBLE_DEVICES=0
NNODES=${NNODES:-1}
NODE_RANK=${NODE_RANK:-0}
PORT=29500
MASTER_ADDR=${MASTER_ADDR:-"127.0.0.1"}

PYTHONPATH="$(dirname $0)/..":$PYTHONPATH \
python -m torch.distributed.launch \
    --nnodes=$NNODES \
    --node_rank=$NODE_RANK \
    --master_addr=$MASTER_ADDR \
    --nproc_per_node=$GPUS \
    --master_port=$PORT \
    $(dirname "$0")/test.py \
    $CONFIG \
    $CHECKPOINT \
    --launcher pytorch \
    ${@:4} 
#export HIP_VISIBLE_DEVICES=1
#NNODES=${NNODES:-1}
#NODE_RANK=${NODE_RANK:-0}
#PORT=29501
#MASTER_ADDR=${MASTER_ADDR:-"127.0.0.1"}
#
#PYTHONPATH="$(dirname $0)/..":$PYTHONPATH \
#nohup python -m torch.distributed.launch \
#    --nnodes=$NNODES \
#    --node_rank=$NODE_RANK \
#    --master_addr=$MASTER_ADDR \
#    --nproc_per_node=$GPUS \
#    --master_port=$PORT \
#    $(dirname "$0")/test.py \
#    $CONFIG \
#    $CHECKPOINT \
#    --launcher pytorch \
#    ${@:4} &
#export HIP_VISIBLE_DEVICES=2
#NNODES=${NNODES:-1}
#NODE_RANK=${NODE_RANK:-0}
#PORT=29502
#MASTER_ADDR=${MASTER_ADDR:-"127.0.0.1"}
#
#PYTHONPATH="$(dirname $0)/..":$PYTHONPATH \
#nohup python -m torch.distributed.launch \
#    --nnodes=$NNODES \
#    --node_rank=$NODE_RANK \
#    --master_addr=$MASTER_ADDR \
#    --nproc_per_node=$GPUS \
#    --master_port=$PORT \
#    $(dirname "$0")/test.py \
#    $CONFIG \
#    $CHECKPOINT \
#    --launcher pytorch \
#    ${@:4} &
#export HIP_VISIBLE_DEVICES=3
#NNODES=${NNODES:-1}
#NODE_RANK=${NODE_RANK:-0}
#PORT=29503
#MASTER_ADDR=${MASTER_ADDR:-"127.0.0.1"}
#
#PYTHONPATH="$(dirname $0)/..":$PYTHONPATH \
#nohup python -m torch.distributed.launch \
#    --nnodes=$NNODES \
#    --node_rank=$NODE_RANK \
#    --master_addr=$MASTER_ADDR \
#    --nproc_per_node=$GPUS \
#    --master_port=$PORT \
#    $(dirname "$0")/test.py \
#    $CONFIG \
#    $CHECKPOINT \
#    --launcher pytorch \
#    ${@:4} &
#export HIP_VISIBLE_DEVICES=4
#NNODES=${NNODES:-1}
#NODE_RANK=${NODE_RANK:-0}
#PORT=29504
#MASTER_ADDR=${MASTER_ADDR:-"127.0.0.1"}
#
#PYTHONPATH="$(dirname $0)/..":$PYTHONPATH \
#nohup python -m torch.distributed.launch \
#    --nnodes=$NNODES \
#    --node_rank=$NODE_RANK \
#    --master_addr=$MASTER_ADDR \
#    --nproc_per_node=$GPUS \
#    --master_port=$PORT \
#    $(dirname "$0")/test.py \
#    $CONFIG \
#    $CHECKPOINT \
#    --launcher pytorch \
#    ${@:4} &
#export HIP_VISIBLE_DEVICES=5
#NNODES=${NNODES:-1}
#NODE_RANK=${NODE_RANK:-0}
#PORT=29505
#MASTER_ADDR=${MASTER_ADDR:-"127.0.0.1"}
#
#PYTHONPATH="$(dirname $0)/..":$PYTHONPATH \
#nohup python -m torch.distributed.launch \
#    --nnodes=$NNODES \
#    --node_rank=$NODE_RANK \
#    --master_addr=$MASTER_ADDR \
#    --nproc_per_node=$GPUS \
#    --master_port=$PORT \
#    $(dirname "$0")/test.py \
#    $CONFIG \
#    $CHECKPOINT \
#    --launcher pytorch \
#    ${@:4} &
#export HIP_VISIBLE_DEVICES=6
#NNODES=${NNODES:-1}
#NODE_RANK=${NODE_RANK:-0}
#PORT=29506
#MASTER_ADDR=${MASTER_ADDR:-"127.0.0.1"}
#
#PYTHONPATH="$(dirname $0)/..":$PYTHONPATH \
#nohup python -m torch.distributed.launch \
#    --nnodes=$NNODES \
#    --node_rank=$NODE_RANK \
#    --master_addr=$MASTER_ADDR \
#    --nproc_per_node=$GPUS \
#    --master_port=$PORT \
#    $(dirname "$0")/test.py \
#    $CONFIG \
#    $CHECKPOINT \
#    --launcher pytorch \
#    ${@:4} &
#export HIP_VISIBLE_DEVICES=7
#NNODES=${NNODES:-1}
#NODE_RANK=${NODE_RANK:-0}
#PORT=29507
#MASTER_ADDR=${MASTER_ADDR:-"127.0.0.1"}
#
#PYTHONPATH="$(dirname $0)/..":$PYTHONPATH \
#nohup python -m torch.distributed.launch \
#    --nnodes=$NNODES \
#    --node_rank=$NODE_RANK \
#    --master_addr=$MASTER_ADDR \
#    --nproc_per_node=$GPUS \
#    --master_port=$PORT \
#    $(dirname "$0")/test.py \
#    $CONFIG \
#    $CHECKPOINT \
#    --launcher pytorch \
#    ${@:4} &
#

