import tensorflow as tf
from tensorflow.python.platform import gfile

pb_path = '/home/sunzhq/workspace/yidong-infer/facenet/facenet/models_m/facenet-tmp/20180408-102900.pb'

with tf.io.gfile.GFile(pb_path, 'rb') as f:
    graph_def = tf.compat.v1.GraphDef()
    graph_def.ParseFromString(f.read())

with tf.Graph().as_default() as graph:
    tf.import_graph_def(graph_def, name='')

ops = graph.get_operations()

# --- 查找 Identity 操作，特别关注可能代表最终输出的 ---
print("--- Identity Nodes (Potential Model Outputs) ---")
identity_ops = [op for op in ops if op.type == "Identity"]

# 存储映射到最终输出的 Identity 信息
final_outputs = []

for op in identity_ops:
    input_to_identity = op.inputs[0]
    producer_op = input_to_identity.op

    # 尝试判断是否是模型的主要输出（例如，名称包含 embedding，或者 producer op 是常见的输出层类型）
    # In Facenet, the final layer before normalization might be called 'embeddings' or similar.
    # Common final ops could be MatMul, Add, BatchMatMul, etc., followed by normalization like L2Norm or similar.
    # Let's look for the most likely candidate based on name patterns common in Facenet models.

    # Look for a name pattern often used for the final embedding vector
    if ('embedding' in input_to_identity.name.lower() or 
        'bottleneck' in input_to_identity.name.lower() or
        producer_op.type in ['MatMul', 'Add', 'BatchMatMulV2']): # Common final computation types
        final_outputs.append({
            'identity_name': op.name,
            'final_output_name': input_to_identity.name,
            'producer_name': producer_op.name,
            'type': producer_op.type,
            'shape': input_to_identity.shape,
            'dtype': input_to_identity.dtype
        })

# Print only the potentially relevant final outputs
if final_outputs:
    print("Potential Model Output Candidates:")
    for out_info in final_outputs:
        print(f"  Identity Op: {out_info['identity_name']}")
        print(f"    Maps Output From: {out_info['producer_name']} (Type: {out_info['type']})")
        print(f"    Final Output Name: {out_info['final_output_name']}")
        print(f"    Shape: {out_info['shape']}, Dtype: {out_info['dtype']}")
        print("  ---")
else:
    print("No obvious final output Identity nodes found matching common patterns.")

# --- Alternative: Check for common output layer names directly (if not mapped by Identity) ---
# This is less likely if Identity is used, but worth a quick check
print("\n--- Checking for Common Embedding Layer Names ---")
potential_embedding_names = [
    'embeddings', 'Bottleneck/BatchNorm/Reshape_1', 'prelogits', 'InceptionResnetV1/Bottleneck/Identity'
    # Add more potential names based on the specific model architecture if needed
]
# Add a suffix like :0 if necessary, TensorFlow usually adds this implicitly for the first output
potential_embedding_names_with_suffix = [name + ':0' for name in potential_embedding_names]

found_embedding_directly = False
for op in ops:
    if op.name in potential_embedding_names or op.name + ':0' in potential_embedding_names_with_suffix:
        print(f"Found potential embedding node directly: {op.name}")
        for output in op.outputs:
             print(f"  Output: {output.name}, Shape: {output.shape}, Dtype: {output.dtype}")
        found_embedding_directly = True
        break # Assume the first match is the one

if not found_embedding_directly:
    print("  No direct match found for common embedding names.")