export MIOPEN_FIND_MODE=1
#export MIOPEN_ENABLE_LOGGING_CMD=1
#export  AMD_OCL_WAIT_COMMAND=1

export TF_USE_CUDNN_BATCHNORM_SPATIAL_PERSISTENT=0
#export TF_USE_CUDNN=0
export TF_ROCM_FUSION_ENABLE=0

source /opt/dtk-22.04.2/env.sh

NUM=1
BS=64
EPOCH_SIZE=$((462413/${BS}))

HIP_VISIBLE_DEVICES=7 python src/train_softmax.py \
--logs_base_dir ./logs/facenet/ \
--models_base_dir ./models/facenet/ \
--data_dir /datasets/facenet/casia_maxpy_mtcnnpy_182/ \
--image_size 160 \
--model_def models.inception_resnet_v1 \
--lfw_dir /datasets/facenet/lfw_mtcnnpy_160/ \
--optimizer ADAM \
--learning_rate -1 \
--max_nrof_epochs 250 \
--keep_probability 0.8 \
--random_crop \
--random_flip \
--use_fixed_image_standardization \
--learning_rate_schedule_file data/learning_rate_schedule_classifier_casia.txt \
--weight_decay 5e-4 \
--embedding_size 512 \
--lfw_distance_metric 1 \
--lfw_use_flipped_images \
--lfw_subtract_mean \
--validation_set_split_ratio 0.05 \
--validate_every_n_epochs 5 \
--batch_size ${BS} \
--epoch_size ${EPOCH_SIZE} \
--prelogits_norm_loss_factor 5e-4  2>&1 | tee facenet_1dcu_${BS}_`date +%Y%m%d%H%M%S`.log
