import torch
import yaml
from espnet2.asr.model import ESPnetASRModel  # ESPnet 2.x 风格

# 加载配置
with open("exp/asr_train_asr_conformer3_wenetspeech_u2pp_large_alldata_sap_specaug_raw_sp_valid.acc.ave_10best/config.yaml", 'r') as f:
    config = yaml.safe_load(f)

# 构建模型（使用配置中的模型参数）
model = ESPnetASRModel(**config["model"])
# 或者根据 config["model"] 逐项构建

# 加载权重
checkpoint = torch.load("exp/asr_train_asr_conformer3_wenetspeech_u2pp_large_alldata_sap_specaug_raw_sp_valid.acc.ave_10best/valid.acc.ave_10best.pth", map_location="cpu")
model.load_state_dict(checkpoint["model"], strict=True)
model.eval()