<!-- Generated by ./scripts/utils/show_asr_result.sh -->
# RESULTS

## Dataset
- Fluent Speech Commands Datset
  - Splits: https://github.com/maseEval/mase/tree/main/slu_splits/fluent_speech_commands/challenge_splits
    - Unseen Speaker Test Set: Test generalisation to new speaker, Similar distribution of speaker diversity in train and test set
      - Additional constraints to increase ASR confusion in test set
    - Unseen Utterance Test Set: Test generalisation to new utterances, Similar distribution of transcript length in train and test set
      - Additional constraints to reduce n-gram overlap with training set
  - Paper: http://arxiv.org/abs/2106.15065

## Environments
- date: `Sun Oct  3 22:25:25 EDT 2021`
- python version: `3.8.11 (default, Aug  3 2021, 15:09:35)  [GCC 7.5.0]`
- espnet version: `espnet 0.10.3a3`
- pytorch version: `pytorch 1.9.0+cu102`
- Git hash: `a1a55e1eef2a74d2b8580d8071ce5229e7fa654c`
  - Commit date: `Mon Nov 8 23:56:06 2021 -0500`
- Pretrained Model
  - Zenodo: https://zenodo.org/record/5656007
  - Hugging Face Hub: https://huggingface.co/espnet/siddhana_fsc_challenge_asr_train_asr_hubert_transformer_adam_specaug_raw_en_word_valid.acc.ave_5best

## Using Transformer based encoder-decoder with finetuned Hubert pre encoder and decoding sentence with spectral augmentation and predicting transcript along with intent
- ASR config: [conf/tuning/train_asr.yaml](conf/tuning/train_asr_hubert_transformer_adam_specaug_finetune.yaml)
- token_type: word
- keep_nbest_models: 5

|dataset|Snt|Intent Classification (%)|
|---|---|---|
|inference_asr_model_valid.acc.ave_5best/spk_test|3366|97.5|
|inference_asr_model_valid.acc.ave_5best/utt_test|3970|78.5|
|inference_asr_model_valid.acc.ave_5best/valid|2624|98.4|

###ASR results

#### WER

|dataset|Snt|Wrd|Corr|Sub|Del|Ins|Err|S.Err|
|---|---|---|---|---|---|---|---|---|
|inference_asr_model_valid.acc.ave_5best/spk_test|3349|14588|98.7|0.9|0.4|0.6|1.9|4.7|
|inference_asr_model_valid.acc.ave_5best/utt_test|4201|18330|87.1|10.6|2.3|3.8|16.7|44.6|
|inference_asr_model_valid.acc.ave_5best/valid|2597|1185|98.9|0.6|0.5|0.3|1.3|2.9 |
