# Copyright (c) OpenMMLab. All rights reserved.
# Pre-defined categories names of various datasets.

VOC2007_CATEGORIES = ('aeroplane', 'bicycle', 'bird', 'boat', 'bottle', 'bus',
                      'car', 'cat', 'chair', 'cow', 'diningtable', 'dog',
                      'horse', 'motorbike', 'person', 'pottedplant', 'sheep',
                      'sofa', 'train', 'tvmonitor')

CUB_CATEGORIES = (
    'Black_footed_Albatross', 'Laysan_Albatross', 'Sooty_Albatross',
    'Groove_billed_Ani', 'Crested_Auklet', 'Least_Auklet', 'Parakeet_Auklet',
    'Rhinoceros_Auklet', 'Brewer_Blackbird', 'Red_winged_Blackbird',
    'Rusty_Blackbird', 'Yellow_headed_Blackbird', 'Bobolink', 'Indigo_Bunting',
    'Lazuli_Bunting', 'Painted_Bunting', 'Cardinal', 'Spotted_Catbird',
    'Gray_Catbird', 'Yellow_breasted_Chat', 'Eastern_Towhee',
    'Chuck_will_Widow', 'Brandt_Cormorant', 'Red_faced_Cormorant',
    'Pelagic_Cormorant', 'Bronzed_Cowbird', 'Shiny_Cowbird', 'Brown_Creeper',
    'American_Crow', 'Fish_Crow', 'Black_billed_Cuckoo', 'Mangrove_Cuckoo',
    'Yellow_billed_Cuckoo', 'Gray_crowned_Rosy_Finch', 'Purple_Finch',
    'Northern_Flicker', 'Acadian_Flycatcher', 'Great_Crested_Flycatcher',
    'Least_Flycatcher', 'Olive_sided_Flycatcher', 'Scissor_tailed_Flycatcher',
    'Vermilion_Flycatcher', 'Yellow_bellied_Flycatcher', 'Frigatebird',
    'Northern_Fulmar', 'Gadwall', 'American_Goldfinch', 'European_Goldfinch',
    'Boat_tailed_Grackle', 'Eared_Grebe', 'Horned_Grebe', 'Pied_billed_Grebe',
    'Western_Grebe', 'Blue_Grosbeak', 'Evening_Grosbeak', 'Pine_Grosbeak',
    'Rose_breasted_Grosbeak', 'Pigeon_Guillemot', 'California_Gull',
    'Glaucous_winged_Gull', 'Heermann_Gull', 'Herring_Gull', 'Ivory_Gull',
    'Ring_billed_Gull', 'Slaty_backed_Gull', 'Western_Gull',
    'Anna_Hummingbird', 'Ruby_throated_Hummingbird', 'Rufous_Hummingbird',
    'Green_Violetear', 'Long_tailed_Jaeger', 'Pomarine_Jaeger', 'Blue_Jay',
    'Florida_Jay', 'Green_Jay', 'Dark_eyed_Junco', 'Tropical_Kingbird',
    'Gray_Kingbird', 'Belted_Kingfisher', 'Green_Kingfisher',
    'Pied_Kingfisher', 'Ringed_Kingfisher', 'White_breasted_Kingfisher',
    'Red_legged_Kittiwake', 'Horned_Lark', 'Pacific_Loon', 'Mallard',
    'Western_Meadowlark', 'Hooded_Merganser', 'Red_breasted_Merganser',
    'Mockingbird', 'Nighthawk', 'Clark_Nutcracker', 'White_breasted_Nuthatch',
    'Baltimore_Oriole', 'Hooded_Oriole', 'Orchard_Oriole', 'Scott_Oriole',
    'Ovenbird', 'Brown_Pelican', 'White_Pelican', 'Western_Wood_Pewee',
    'Sayornis', 'American_Pipit', 'Whip_poor_Will', 'Horned_Puffin',
    'Common_Raven', 'White_necked_Raven', 'American_Redstart', 'Geococcyx',
    'Loggerhead_Shrike', 'Great_Grey_Shrike', 'Baird_Sparrow',
    'Black_throated_Sparrow', 'Brewer_Sparrow', 'Chipping_Sparrow',
    'Clay_colored_Sparrow', 'House_Sparrow', 'Field_Sparrow', 'Fox_Sparrow',
    'Grasshopper_Sparrow', 'Harris_Sparrow', 'Henslow_Sparrow',
    'Le_Conte_Sparrow', 'Lincoln_Sparrow', 'Nelson_Sharp_tailed_Sparrow',
    'Savannah_Sparrow', 'Seaside_Sparrow', 'Song_Sparrow', 'Tree_Sparrow',
    'Vesper_Sparrow', 'White_crowned_Sparrow', 'White_throated_Sparrow',
    'Cape_Glossy_Starling', 'Bank_Swallow', 'Barn_Swallow', 'Cliff_Swallow',
    'Tree_Swallow', 'Scarlet_Tanager', 'Summer_Tanager', 'Artic_Tern',
    'Black_Tern', 'Caspian_Tern', 'Common_Tern', 'Elegant_Tern',
    'Forsters_Tern', 'Least_Tern', 'Green_tailed_Towhee', 'Brown_Thrasher',
    'Sage_Thrasher', 'Black_capped_Vireo', 'Blue_headed_Vireo',
    'Philadelphia_Vireo', 'Red_eyed_Vireo', 'Warbling_Vireo',
    'White_eyed_Vireo', 'Yellow_throated_Vireo', 'Bay_breasted_Warbler',
    'Black_and_white_Warbler', 'Black_throated_Blue_Warbler',
    'Blue_winged_Warbler', 'Canada_Warbler', 'Cape_May_Warbler',
    'Cerulean_Warbler', 'Chestnut_sided_Warbler', 'Golden_winged_Warbler',
    'Hooded_Warbler', 'Kentucky_Warbler', 'Magnolia_Warbler',
    'Mourning_Warbler', 'Myrtle_Warbler', 'Nashville_Warbler',
    'Orange_crowned_Warbler', 'Palm_Warbler', 'Pine_Warbler',
    'Prairie_Warbler', 'Prothonotary_Warbler', 'Swainson_Warbler',
    'Tennessee_Warbler', 'Wilson_Warbler', 'Worm_eating_Warbler',
    'Yellow_Warbler', 'Northern_Waterthrush', 'Louisiana_Waterthrush',
    'Bohemian_Waxwing', 'Cedar_Waxwing', 'American_Three_toed_Woodpecker',
    'Pileated_Woodpecker', 'Red_bellied_Woodpecker', 'Red_cockaded_Woodpecker',
    'Red_headed_Woodpecker', 'Downy_Woodpecker', 'Bewick_Wren', 'Cactus_Wren',
    'Carolina_Wren', 'House_Wren', 'Marsh_Wren', 'Rock_Wren', 'Winter_Wren',
    'Common_Yellowthroat')

IMAGENET_CATEGORIES = (
    'tench, Tinca tinca',
    'goldfish, Carassius auratus',
    'great white shark, white shark, man-eater, man-eating shark, Carcharodon carcharias',  # noqa: E501
    'tiger shark, Galeocerdo cuvieri',
    'hammerhead, hammerhead shark',
    'electric ray, crampfish, numbfish, torpedo',
    'stingray',
    'cock',
    'hen',
    'ostrich, Struthio camelus',
    'brambling, Fringilla montifringilla',
    'goldfinch, Carduelis carduelis',
    'house finch, linnet, Carpodacus mexicanus',
    'junco, snowbird',
    'indigo bunting, indigo finch, indigo bird, Passerina cyanea',
    'robin, American robin, Turdus migratorius',
    'bulbul',
    'jay',
    'magpie',
    'chickadee',
    'water ouzel, dipper',
    'kite',
    'bald eagle, American eagle, Haliaeetus leucocephalus',
    'vulture',
    'great grey owl, great gray owl, Strix nebulosa',
    'European fire salamander, Salamandra salamandra',
    'common newt, Triturus vulgaris',
    'eft',
    'spotted salamander, Ambystoma maculatum',
    'axolotl, mud puppy, Ambystoma mexicanum',
    'bullfrog, Rana catesbeiana',
    'tree frog, tree-frog',
    'tailed frog, bell toad, ribbed toad, tailed toad, Ascaphus trui',
    'loggerhead, loggerhead turtle, Caretta caretta',
    'leatherback turtle, leatherback, leathery turtle, Dermochelys coriacea',  # noqa: E501
    'mud turtle',
    'terrapin',
    'box turtle, box tortoise',
    'banded gecko',
    'common iguana, iguana, Iguana iguana',
    'American chameleon, anole, Anolis carolinensis',
    'whiptail, whiptail lizard',
    'agama',
    'frilled lizard, Chlamydosaurus kingi',
    'alligator lizard',
    'Gila monster, Heloderma suspectum',
    'green lizard, Lacerta viridis',
    'African chameleon, Chamaeleo chamaeleon',
    'Komodo dragon, Komodo lizard, dragon lizard, giant lizard, Varanus komodoensis',  # noqa: E501
    'African crocodile, Nile crocodile, Crocodylus niloticus',
    'American alligator, Alligator mississipiensis',
    'triceratops',
    'thunder snake, worm snake, Carphophis amoenus',
    'ringneck snake, ring-necked snake, ring snake',
    'hognose snake, puff adder, sand viper',
    'green snake, grass snake',
    'king snake, kingsnake',
    'garter snake, grass snake',
    'water snake',
    'vine snake',
    'night snake, Hypsiglena torquata',
    'boa constrictor, Constrictor constrictor',
    'rock python, rock snake, Python sebae',
    'Indian cobra, Naja naja',
    'green mamba',
    'sea snake',
    'horned viper, cerastes, sand viper, horned asp, Cerastes cornutus',
    'diamondback, diamondback rattlesnake, Crotalus adamanteus',
    'sidewinder, horned rattlesnake, Crotalus cerastes',
    'trilobite',
    'harvestman, daddy longlegs, Phalangium opilio',
    'scorpion',
    'black and gold garden spider, Argiope aurantia',
    'barn spider, Araneus cavaticus',
    'garden spider, Aranea diademata',
    'black widow, Latrodectus mactans',
    'tarantula',
    'wolf spider, hunting spider',
    'tick',
    'centipede',
    'black grouse',
    'ptarmigan',
    'ruffed grouse, partridge, Bonasa umbellus',
    'prairie chicken, prairie grouse, prairie fowl',
    'peacock',
    'quail',
    'partridge',
    'African grey, African gray, Psittacus erithacus',
    'macaw',
    'sulphur-crested cockatoo, Kakatoe galerita, Cacatua galerita',
    'lorikeet',
    'coucal',
    'bee eater',
    'hornbill',
    'hummingbird',
    'jacamar',
    'toucan',
    'drake',
    'red-breasted merganser, Mergus serrator',
    'goose',
    'black swan, Cygnus atratus',
    'tusker',
    'echidna, spiny anteater, anteater',
    'platypus, duckbill, duckbilled platypus, duck-billed platypus, Ornithorhynchus anatinus',  # noqa: E501
    'wallaby, brush kangaroo',
    'koala, koala bear, kangaroo bear, native bear, Phascolarctos cinereus',  # noqa: E501
    'wombat',
    'jellyfish',
    'sea anemone, anemone',
    'brain coral',
    'flatworm, platyhelminth',
    'nematode, nematode worm, roundworm',
    'conch',
    'snail',
    'slug',
    'sea slug, nudibranch',
    'chiton, coat-of-mail shell, sea cradle, polyplacophore',
    'chambered nautilus, pearly nautilus, nautilus',
    'Dungeness crab, Cancer magister',
    'rock crab, Cancer irroratus',
    'fiddler crab',
    'king crab, Alaska crab, Alaskan king crab, Alaska king crab, Paralithodes camtschatica',  # noqa: E501
    'American lobster, Northern lobster, Maine lobster, Homarus americanus',  # noqa: E501
    'spiny lobster, langouste, rock lobster, crawfish, crayfish, sea crawfish',  # noqa: E501
    'crayfish, crawfish, crawdad, crawdaddy',
    'hermit crab',
    'isopod',
    'white stork, Ciconia ciconia',
    'black stork, Ciconia nigra',
    'spoonbill',
    'flamingo',
    'little blue heron, Egretta caerulea',
    'American egret, great white heron, Egretta albus',
    'bittern',
    'crane',
    'limpkin, Aramus pictus',
    'European gallinule, Porphyrio porphyrio',
    'American coot, marsh hen, mud hen, water hen, Fulica americana',
    'bustard',
    'ruddy turnstone, Arenaria interpres',
    'red-backed sandpiper, dunlin, Erolia alpina',
    'redshank, Tringa totanus',
    'dowitcher',
    'oystercatcher, oyster catcher',
    'pelican',
    'king penguin, Aptenodytes patagonica',
    'albatross, mollymawk',
    'grey whale, gray whale, devilfish, Eschrichtius gibbosus, Eschrichtius robustus',  # noqa: E501
    'killer whale, killer, orca, grampus, sea wolf, Orcinus orca',
    'dugong, Dugong dugon',
    'sea lion',
    'Chihuahua',
    'Japanese spaniel',
    'Maltese dog, Maltese terrier, Maltese',
    'Pekinese, Pekingese, Peke',
    'Shih-Tzu',
    'Blenheim spaniel',
    'papillon',
    'toy terrier',
    'Rhodesian ridgeback',
    'Afghan hound, Afghan',
    'basset, basset hound',
    'beagle',
    'bloodhound, sleuthhound',
    'bluetick',
    'black-and-tan coonhound',
    'Walker hound, Walker foxhound',
    'English foxhound',
    'redbone',
    'borzoi, Russian wolfhound',
    'Irish wolfhound',
    'Italian greyhound',
    'whippet',
    'Ibizan hound, Ibizan Podenco',
    'Norwegian elkhound, elkhound',
    'otterhound, otter hound',
    'Saluki, gazelle hound',
    'Scottish deerhound, deerhound',
    'Weimaraner',
    'Staffordshire bullterrier, Staffordshire bull terrier',
    'American Staffordshire terrier, Staffordshire terrier, American pit bull terrier, pit bull terrier',  # noqa: E501
    'Bedlington terrier',
    'Border terrier',
    'Kerry blue terrier',
    'Irish terrier',
    'Norfolk terrier',
    'Norwich terrier',
    'Yorkshire terrier',
    'wire-haired fox terrier',
    'Lakeland terrier',
    'Sealyham terrier, Sealyham',
    'Airedale, Airedale terrier',
    'cairn, cairn terrier',
    'Australian terrier',
    'Dandie Dinmont, Dandie Dinmont terrier',
    'Boston bull, Boston terrier',
    'miniature schnauzer',
    'giant schnauzer',
    'standard schnauzer',
    'Scotch terrier, Scottish terrier, Scottie',
    'Tibetan terrier, chrysanthemum dog',
    'silky terrier, Sydney silky',
    'soft-coated wheaten terrier',
    'West Highland white terrier',
    'Lhasa, Lhasa apso',
    'flat-coated retriever',
    'curly-coated retriever',
    'golden retriever',
    'Labrador retriever',
    'Chesapeake Bay retriever',
    'German short-haired pointer',
    'vizsla, Hungarian pointer',
    'English setter',
    'Irish setter, red setter',
    'Gordon setter',
    'Brittany spaniel',
    'clumber, clumber spaniel',
    'English springer, English springer spaniel',
    'Welsh springer spaniel',
    'cocker spaniel, English cocker spaniel, cocker',
    'Sussex spaniel',
    'Irish water spaniel',
    'kuvasz',
    'schipperke',
    'groenendael',
    'malinois',
    'briard',
    'kelpie',
    'komondor',
    'Old English sheepdog, bobtail',
    'Shetland sheepdog, Shetland sheep dog, Shetland',
    'collie',
    'Border collie',
    'Bouvier des Flandres, Bouviers des Flandres',
    'Rottweiler',
    'German shepherd, German shepherd dog, German police dog, alsatian',
    'Doberman, Doberman pinscher',
    'miniature pinscher',
    'Greater Swiss Mountain dog',
    'Bernese mountain dog',
    'Appenzeller',
    'EntleBucher',
    'boxer',
    'bull mastiff',
    'Tibetan mastiff',
    'French bulldog',
    'Great Dane',
    'Saint Bernard, St Bernard',
    'Eskimo dog, husky',
    'malamute, malemute, Alaskan malamute',
    'Siberian husky',
    'dalmatian, coach dog, carriage dog',
    'affenpinscher, monkey pinscher, monkey dog',
    'basenji',
    'pug, pug-dog',
    'Leonberg',
    'Newfoundland, Newfoundland dog',
    'Great Pyrenees',
    'Samoyed, Samoyede',
    'Pomeranian',
    'chow, chow chow',
    'keeshond',
    'Brabancon griffon',
    'Pembroke, Pembroke Welsh corgi',
    'Cardigan, Cardigan Welsh corgi',
    'toy poodle',
    'miniature poodle',
    'standard poodle',
    'Mexican hairless',
    'timber wolf, grey wolf, gray wolf, Canis lupus',
    'white wolf, Arctic wolf, Canis lupus tundrarum',
    'red wolf, maned wolf, Canis rufus, Canis niger',
    'coyote, prairie wolf, brush wolf, Canis latrans',
    'dingo, warrigal, warragal, Canis dingo',
    'dhole, Cuon alpinus',
    'African hunting dog, hyena dog, Cape hunting dog, Lycaon pictus',
    'hyena, hyaena',
    'red fox, Vulpes vulpes',
    'kit fox, Vulpes macrotis',
    'Arctic fox, white fox, Alopex lagopus',
    'grey fox, gray fox, Urocyon cinereoargenteus',
    'tabby, tabby cat',
    'tiger cat',
    'Persian cat',
    'Siamese cat, Siamese',
    'Egyptian cat',
    'cougar, puma, catamount, mountain lion, painter, panther, Felis concolor',  # noqa: E501
    'lynx, catamount',
    'leopard, Panthera pardus',
    'snow leopard, ounce, Panthera uncia',
    'jaguar, panther, Panthera onca, Felis onca',
    'lion, king of beasts, Panthera leo',
    'tiger, Panthera tigris',
    'cheetah, chetah, Acinonyx jubatus',
    'brown bear, bruin, Ursus arctos',
    'American black bear, black bear, Ursus americanus, Euarctos americanus',  # noqa: E501
    'ice bear, polar bear, Ursus Maritimus, Thalarctos maritimus',
    'sloth bear, Melursus ursinus, Ursus ursinus',
    'mongoose',
    'meerkat, mierkat',
    'tiger beetle',
    'ladybug, ladybeetle, lady beetle, ladybird, ladybird beetle',
    'ground beetle, carabid beetle',
    'long-horned beetle, longicorn, longicorn beetle',
    'leaf beetle, chrysomelid',
    'dung beetle',
    'rhinoceros beetle',
    'weevil',
    'fly',
    'bee',
    'ant, emmet, pismire',
    'grasshopper, hopper',
    'cricket',
    'walking stick, walkingstick, stick insect',
    'cockroach, roach',
    'mantis, mantid',
    'cicada, cicala',
    'leafhopper',
    'lacewing, lacewing fly',
    "dragonfly, darning needle, devil's darning needle, sewing needle, snake feeder, snake doctor, mosquito hawk, skeeter hawk",  # noqa: E501
    'damselfly',
    'admiral',
    'ringlet, ringlet butterfly',
    'monarch, monarch butterfly, milkweed butterfly, Danaus plexippus',
    'cabbage butterfly',
    'sulphur butterfly, sulfur butterfly',
    'lycaenid, lycaenid butterfly',
    'starfish, sea star',
    'sea urchin',
    'sea cucumber, holothurian',
    'wood rabbit, cottontail, cottontail rabbit',
    'hare',
    'Angora, Angora rabbit',
    'hamster',
    'porcupine, hedgehog',
    'fox squirrel, eastern fox squirrel, Sciurus niger',
    'marmot',
    'beaver',
    'guinea pig, Cavia cobaya',
    'sorrel',
    'zebra',
    'hog, pig, grunter, squealer, Sus scrofa',
    'wild boar, boar, Sus scrofa',
    'warthog',
    'hippopotamus, hippo, river horse, Hippopotamus amphibius',
    'ox',
    'water buffalo, water ox, Asiatic buffalo, Bubalus bubalis',
    'bison',
    'ram, tup',
    'bighorn, bighorn sheep, cimarron, Rocky Mountain bighorn, Rocky Mountain sheep, Ovis canadensis',  # noqa: E501
    'ibex, Capra ibex',
    'hartebeest',
    'impala, Aepyceros melampus',
    'gazelle',
    'Arabian camel, dromedary, Camelus dromedarius',
    'llama',
    'weasel',
    'mink',
    'polecat, fitch, foulmart, foumart, Mustela putorius',
    'black-footed ferret, ferret, Mustela nigripes',
    'otter',
    'skunk, polecat, wood pussy',
    'badger',
    'armadillo',
    'three-toed sloth, ai, Bradypus tridactylus',
    'orangutan, orang, orangutang, Pongo pygmaeus',
    'gorilla, Gorilla gorilla',
    'chimpanzee, chimp, Pan troglodytes',
    'gibbon, Hylobates lar',
    'siamang, Hylobates syndactylus, Symphalangus syndactylus',
    'guenon, guenon monkey',
    'patas, hussar monkey, Erythrocebus patas',
    'baboon',
    'macaque',
    'langur',
    'colobus, colobus monkey',
    'proboscis monkey, Nasalis larvatus',
    'marmoset',
    'capuchin, ringtail, Cebus capucinus',
    'howler monkey, howler',
    'titi, titi monkey',
    'spider monkey, Ateles geoffroyi',
    'squirrel monkey, Saimiri sciureus',
    'Madagascar cat, ring-tailed lemur, Lemur catta',
    'indri, indris, Indri indri, Indri brevicaudatus',
    'Indian elephant, Elephas maximus',
    'African elephant, Loxodonta africana',
    'lesser panda, red panda, panda, bear cat, cat bear, Ailurus fulgens',
    'giant panda, panda, panda bear, coon bear, Ailuropoda melanoleuca',
    'barracouta, snoek',
    'eel',
    'coho, cohoe, coho salmon, blue jack, silver salmon, Oncorhynchus kisutch',  # noqa: E501
    'rock beauty, Holocanthus tricolor',
    'anemone fish',
    'sturgeon',
    'gar, garfish, garpike, billfish, Lepisosteus osseus',
    'lionfish',
    'puffer, pufferfish, blowfish, globefish',
    'abacus',
    'abaya',
    "academic gown, academic robe, judge's robe",
    'accordion, piano accordion, squeeze box',
    'acoustic guitar',
    'aircraft carrier, carrier, flattop, attack aircraft carrier',
    'airliner',
    'airship, dirigible',
    'altar',
    'ambulance',
    'amphibian, amphibious vehicle',
    'analog clock',
    'apiary, bee house',
    'apron',
    'ashcan, trash can, garbage can, wastebin, ash bin, ash-bin, ashbin, dustbin, trash barrel, trash bin',  # noqa: E501
    'assault rifle, assault gun',
    'backpack, back pack, knapsack, packsack, rucksack, haversack',
    'bakery, bakeshop, bakehouse',
    'balance beam, beam',
    'balloon',
    'ballpoint, ballpoint pen, ballpen, Biro',
    'Band Aid',
    'banjo',
    'bannister, banister, balustrade, balusters, handrail',
    'barbell',
    'barber chair',
    'barbershop',
    'barn',
    'barometer',
    'barrel, cask',
    'barrow, garden cart, lawn cart, wheelbarrow',
    'baseball',
    'basketball',
    'bassinet',
    'bassoon',
    'bathing cap, swimming cap',
    'bath towel',
    'bathtub, bathing tub, bath, tub',
    'beach wagon, station wagon, wagon, estate car, beach waggon, station waggon, waggon',  # noqa: E501
    'beacon, lighthouse, beacon light, pharos',
    'beaker',
    'bearskin, busby, shako',
    'beer bottle',
    'beer glass',
    'bell cote, bell cot',
    'bib',
    'bicycle-built-for-two, tandem bicycle, tandem',
    'bikini, two-piece',
    'binder, ring-binder',
    'binoculars, field glasses, opera glasses',
    'birdhouse',
    'boathouse',
    'bobsled, bobsleigh, bob',
    'bolo tie, bolo, bola tie, bola',
    'bonnet, poke bonnet',
    'bookcase',
    'bookshop, bookstore, bookstall',
    'bottlecap',
    'bow',
    'bow tie, bow-tie, bowtie',
    'brass, memorial tablet, plaque',
    'brassiere, bra, bandeau',
    'breakwater, groin, groyne, mole, bulwark, seawall, jetty',
    'breastplate, aegis, egis',
    'broom',
    'bucket, pail',
    'buckle',
    'bulletproof vest',
    'bullet train, bullet',
    'butcher shop, meat market',
    'cab, hack, taxi, taxicab',
    'caldron, cauldron',
    'candle, taper, wax light',
    'cannon',
    'canoe',
    'can opener, tin opener',
    'cardigan',
    'car mirror',
    'carousel, carrousel, merry-go-round, roundabout, whirligig',
    "carpenter's kit, tool kit",
    'carton',
    'car wheel',
    'cash machine, cash dispenser, automated teller machine, automatic teller machine, automated teller, automatic teller, ATM',  # noqa: E501
    'cassette',
    'cassette player',
    'castle',
    'catamaran',
    'CD player',
    'cello, violoncello',
    'cellular telephone, cellular phone, cellphone, cell, mobile phone',
    'chain',
    'chainlink fence',
    'chain mail, ring mail, mail, chain armor, chain armour, ring armor, ring armour',  # noqa: E501
    'chain saw, chainsaw',
    'chest',
    'chiffonier, commode',
    'chime, bell, gong',
    'china cabinet, china closet',
    'Christmas stocking',
    'church, church building',
    'cinema, movie theater, movie theatre, movie house, picture palace',
    'cleaver, meat cleaver, chopper',
    'cliff dwelling',
    'cloak',
    'clog, geta, patten, sabot',
    'cocktail shaker',
    'coffee mug',
    'coffeepot',
    'coil, spiral, volute, whorl, helix',
    'combination lock',
    'computer keyboard, keypad',
    'confectionery, confectionary, candy store',
    'container ship, containership, container vessel',
    'convertible',
    'corkscrew, bottle screw',
    'cornet, horn, trumpet, trump',
    'cowboy boot',
    'cowboy hat, ten-gallon hat',
    'cradle',
    'crane',
    'crash helmet',
    'crate',
    'crib, cot',
    'Crock Pot',
    'croquet ball',
    'crutch',
    'cuirass',
    'dam, dike, dyke',
    'desk',
    'desktop computer',
    'dial telephone, dial phone',
    'diaper, nappy, napkin',
    'digital clock',
    'digital watch',
    'dining table, board',
    'dishrag, dishcloth',
    'dishwasher, dish washer, dishwashing machine',
    'disk brake, disc brake',
    'dock, dockage, docking facility',
    'dogsled, dog sled, dog sleigh',
    'dome',
    'doormat, welcome mat',
    'drilling platform, offshore rig',
    'drum, membranophone, tympan',
    'drumstick',
    'dumbbell',
    'Dutch oven',
    'electric fan, blower',
    'electric guitar',
    'electric locomotive',
    'entertainment center',
    'envelope',
    'espresso maker',
    'face powder',
    'feather boa, boa',
    'file, file cabinet, filing cabinet',
    'fireboat',
    'fire engine, fire truck',
    'fire screen, fireguard',
    'flagpole, flagstaff',
    'flute, transverse flute',
    'folding chair',
    'football helmet',
    'forklift',
    'fountain',
    'fountain pen',
    'four-poster',
    'freight car',
    'French horn, horn',
    'frying pan, frypan, skillet',
    'fur coat',
    'garbage truck, dustcart',
    'gasmask, respirator, gas helmet',
    'gas pump, gasoline pump, petrol pump, island dispenser',
    'goblet',
    'go-kart',
    'golf ball',
    'golfcart, golf cart',
    'gondola',
    'gong, tam-tam',
    'gown',
    'grand piano, grand',
    'greenhouse, nursery, glasshouse',
    'grille, radiator grille',
    'grocery store, grocery, food market, market',
    'guillotine',
    'hair slide',
    'hair spray',
    'half track',
    'hammer',
    'hamper',
    'hand blower, blow dryer, blow drier, hair dryer, hair drier',
    'hand-held computer, hand-held microcomputer',
    'handkerchief, hankie, hanky, hankey',
    'hard disc, hard disk, fixed disk',
    'harmonica, mouth organ, harp, mouth harp',
    'harp',
    'harvester, reaper',
    'hatchet',
    'holster',
    'home theater, home theatre',
    'honeycomb',
    'hook, claw',
    'hoopskirt, crinoline',
    'horizontal bar, high bar',
    'horse cart, horse-cart',
    'hourglass',
    'iPod',
    'iron, smoothing iron',
    "jack-o'-lantern",
    'jean, blue jean, denim',
    'jeep, landrover',
    'jersey, T-shirt, tee shirt',
    'jigsaw puzzle',
    'jinrikisha, ricksha, rickshaw',
    'joystick',
    'kimono',
    'knee pad',
    'knot',
    'lab coat, laboratory coat',
    'ladle',
    'lampshade, lamp shade',
    'laptop, laptop computer',
    'lawn mower, mower',
    'lens cap, lens cover',
    'letter opener, paper knife, paperknife',
    'library',
    'lifeboat',
    'lighter, light, igniter, ignitor',
    'limousine, limo',
    'liner, ocean liner',
    'lipstick, lip rouge',
    'Loafer',
    'lotion',
    'loudspeaker, speaker, speaker unit, loudspeaker system, speaker system',  # noqa: E501
    "loupe, jeweler's loupe",
    'lumbermill, sawmill',
    'magnetic compass',
    'mailbag, postbag',
    'mailbox, letter box',
    'maillot',
    'maillot, tank suit',
    'manhole cover',
    'maraca',
    'marimba, xylophone',
    'mask',
    'matchstick',
    'maypole',
    'maze, labyrinth',
    'measuring cup',
    'medicine chest, medicine cabinet',
    'megalith, megalithic structure',
    'microphone, mike',
    'microwave, microwave oven',
    'military uniform',
    'milk can',
    'minibus',
    'miniskirt, mini',
    'minivan',
    'missile',
    'mitten',
    'mixing bowl',
    'mobile home, manufactured home',
    'Model T',
    'modem',
    'monastery',
    'monitor',
    'moped',
    'mortar',
    'mortarboard',
    'mosque',
    'mosquito net',
    'motor scooter, scooter',
    'mountain bike, all-terrain bike, off-roader',
    'mountain tent',
    'mouse, computer mouse',
    'mousetrap',
    'moving van',
    'muzzle',
    'nail',
    'neck brace',
    'necklace',
    'nipple',
    'notebook, notebook computer',
    'obelisk',
    'oboe, hautboy, hautbois',
    'ocarina, sweet potato',
    'odometer, hodometer, mileometer, milometer',
    'oil filter',
    'organ, pipe organ',
    'oscilloscope, scope, cathode-ray oscilloscope, CRO',
    'overskirt',
    'oxcart',
    'oxygen mask',
    'packet',
    'paddle, boat paddle',
    'paddlewheel, paddle wheel',
    'padlock',
    'paintbrush',
    "pajama, pyjama, pj's, jammies",
    'palace',
    'panpipe, pandean pipe, syrinx',
    'paper towel',
    'parachute, chute',
    'parallel bars, bars',
    'park bench',
    'parking meter',
    'passenger car, coach, carriage',
    'patio, terrace',
    'pay-phone, pay-station',
    'pedestal, plinth, footstall',
    'pencil box, pencil case',
    'pencil sharpener',
    'perfume, essence',
    'Petri dish',
    'photocopier',
    'pick, plectrum, plectron',
    'pickelhaube',
    'picket fence, paling',
    'pickup, pickup truck',
    'pier',
    'piggy bank, penny bank',
    'pill bottle',
    'pillow',
    'ping-pong ball',
    'pinwheel',
    'pirate, pirate ship',
    'pitcher, ewer',
    "plane, carpenter's plane, woodworking plane",
    'planetarium',
    'plastic bag',
    'plate rack',
    'plow, plough',
    "plunger, plumber's helper",
    'Polaroid camera, Polaroid Land camera',
    'pole',
    'police van, police wagon, paddy wagon, patrol wagon, wagon, black Maria',  # noqa: E501
    'poncho',
    'pool table, billiard table, snooker table',
    'pop bottle, soda bottle',
    'pot, flowerpot',
    "potter's wheel",
    'power drill',
    'prayer rug, prayer mat',
    'printer',
    'prison, prison house',
    'projectile, missile',
    'projector',
    'puck, hockey puck',
    'punching bag, punch bag, punching ball, punchball',
    'purse',
    'quill, quill pen',
    'quilt, comforter, comfort, puff',
    'racer, race car, racing car',
    'racket, racquet',
    'radiator',
    'radio, wireless',
    'radio telescope, radio reflector',
    'rain barrel',
    'recreational vehicle, RV, R.V.',
    'reel',
    'reflex camera',
    'refrigerator, icebox',
    'remote control, remote',
    'restaurant, eating house, eating place, eatery',
    'revolver, six-gun, six-shooter',
    'rifle',
    'rocking chair, rocker',
    'rotisserie',
    'rubber eraser, rubber, pencil eraser',
    'rugby ball',
    'rule, ruler',
    'running shoe',
    'safe',
    'safety pin',
    'saltshaker, salt shaker',
    'sandal',
    'sarong',
    'sax, saxophone',
    'scabbard',
    'scale, weighing machine',
    'school bus',
    'schooner',
    'scoreboard',
    'screen, CRT screen',
    'screw',
    'screwdriver',
    'seat belt, seatbelt',
    'sewing machine',
    'shield, buckler',
    'shoe shop, shoe-shop, shoe store',
    'shoji',
    'shopping basket',
    'shopping cart',
    'shovel',
    'shower cap',
    'shower curtain',
    'ski',
    'ski mask',
    'sleeping bag',
    'slide rule, slipstick',
    'sliding door',
    'slot, one-armed bandit',
    'snorkel',
    'snowmobile',
    'snowplow, snowplough',
    'soap dispenser',
    'soccer ball',
    'sock',
    'solar dish, solar collector, solar furnace',
    'sombrero',
    'soup bowl',
    'space bar',
    'space heater',
    'space shuttle',
    'spatula',
    'speedboat',
    "spider web, spider's web",
    'spindle',
    'sports car, sport car',
    'spotlight, spot',
    'stage',
    'steam locomotive',
    'steel arch bridge',
    'steel drum',
    'stethoscope',
    'stole',
    'stone wall',
    'stopwatch, stop watch',
    'stove',
    'strainer',
    'streetcar, tram, tramcar, trolley, trolley car',
    'stretcher',
    'studio couch, day bed',
    'stupa, tope',
    'submarine, pigboat, sub, U-boat',
    'suit, suit of clothes',
    'sundial',
    'sunglass',
    'sunglasses, dark glasses, shades',
    'sunscreen, sunblock, sun blocker',
    'suspension bridge',
    'swab, swob, mop',
    'sweatshirt',
    'swimming trunks, bathing trunks',
    'swing',
    'switch, electric switch, electrical switch',
    'syringe',
    'table lamp',
    'tank, army tank, armored combat vehicle, armoured combat vehicle',
    'tape player',
    'teapot',
    'teddy, teddy bear',
    'television, television system',
    'tennis ball',
    'thatch, thatched roof',
    'theater curtain, theatre curtain',
    'thimble',
    'thresher, thrasher, threshing machine',
    'throne',
    'tile roof',
    'toaster',
    'tobacco shop, tobacconist shop, tobacconist',
    'toilet seat',
    'torch',
    'totem pole',
    'tow truck, tow car, wrecker',
    'toyshop',
    'tractor',
    'trailer truck, tractor trailer, trucking rig, rig, articulated lorry, semi',  # noqa: E501
    'tray',
    'trench coat',
    'tricycle, trike, velocipede',
    'trimaran',
    'tripod',
    'triumphal arch',
    'trolleybus, trolley coach, trackless trolley',
    'trombone',
    'tub, vat',
    'turnstile',
    'typewriter keyboard',
    'umbrella',
    'unicycle, monocycle',
    'upright, upright piano',
    'vacuum, vacuum cleaner',
    'vase',
    'vault',
    'velvet',
    'vending machine',
    'vestment',
    'viaduct',
    'violin, fiddle',
    'volleyball',
    'waffle iron',
    'wall clock',
    'wallet, billfold, notecase, pocketbook',
    'wardrobe, closet, press',
    'warplane, military plane',
    'washbasin, handbasin, washbowl, lavabo, wash-hand basin',
    'washer, automatic washer, washing machine',
    'water bottle',
    'water jug',
    'water tower',
    'whiskey jug',
    'whistle',
    'wig',
    'window screen',
    'window shade',
    'Windsor tie',
    'wine bottle',
    'wing',
    'wok',
    'wooden spoon',
    'wool, woolen, woollen',
    'worm fence, snake fence, snake-rail fence, Virginia fence',
    'wreck',
    'yawl',
    'yurt',
    'web site, website, internet site, site',
    'comic book',
    'crossword puzzle, crossword',
    'street sign',
    'traffic light, traffic signal, stoplight',
    'book jacket, dust cover, dust jacket, dust wrapper',
    'menu',
    'plate',
    'guacamole',
    'consomme',
    'hot pot, hotpot',
    'trifle',
    'ice cream, icecream',
    'ice lolly, lolly, lollipop, popsicle',
    'French loaf',
    'bagel, beigel',
    'pretzel',
    'cheeseburger',
    'hotdog, hot dog, red hot',
    'mashed potato',
    'head cabbage',
    'broccoli',
    'cauliflower',
    'zucchini, courgette',
    'spaghetti squash',
    'acorn squash',
    'butternut squash',
    'cucumber, cuke',
    'artichoke, globe artichoke',
    'bell pepper',
    'cardoon',
    'mushroom',
    'Granny Smith',
    'strawberry',
    'orange',
    'lemon',
    'fig',
    'pineapple, ananas',
    'banana',
    'jackfruit, jak, jack',
    'custard apple',
    'pomegranate',
    'hay',
    'carbonara',
    'chocolate sauce, chocolate syrup',
    'dough',
    'meat loaf, meatloaf',
    'pizza, pizza pie',
    'potpie',
    'burrito',
    'red wine',
    'espresso',
    'cup',
    'eggnog',
    'alp',
    'bubble',
    'cliff, drop, drop-off',
    'coral reef',
    'geyser',
    'lakeside, lakeshore',
    'promontory, headland, head, foreland',
    'sandbar, sand bar',
    'seashore, coast, seacoast, sea-coast',
    'valley, vale',
    'volcano',
    'ballplayer, baseball player',
    'groom, bridegroom',
    'scuba diver',
    'rapeseed',
    'daisy',
    "yellow lady's slipper, yellow lady-slipper, Cypripedium calceolus, Cypripedium parviflorum",  # noqa: E501
    'corn',
    'acorn',
    'hip, rose hip, rosehip',
    'buckeye, horse chestnut, conker',
    'coral fungus',
    'agaric',
    'gyromitra',
    'stinkhorn, carrion fungus',
    'earthstar',
    'hen-of-the-woods, hen of the woods, Polyporus frondosus, Grifola frondosa',  # noqa: E501
    'bolete',
    'ear, spike, capitulum',
    'toilet tissue, toilet paper, bathroom tissue')

CIFAR10_CATEGORIES = ('airplane', 'automobile', 'bird', 'cat', 'deer', 'dog',
                      'frog', 'horse', 'ship', 'truck')

CIFAR100_CATEGORIES = (
    'apple', 'aquarium_fish', 'baby', 'bear', 'beaver', 'bed', 'bee', 'beetle',
    'bicycle', 'bottle', 'bowl', 'boy', 'bridge', 'bus', 'butterfly', 'camel',
    'can', 'castle', 'caterpillar', 'cattle', 'chair', 'chimpanzee', 'clock',
    'cloud', 'cockroach', 'couch', 'crab', 'crocodile', 'cup', 'dinosaur',
    'dolphin', 'elephant', 'flatfish', 'forest', 'fox', 'girl', 'hamster',
    'house', 'kangaroo', 'keyboard', 'lamp', 'lawn_mower', 'leopard', 'lion',
    'lizard', 'lobster', 'man', 'maple_tree', 'motorcycle', 'mountain',
    'mouse', 'mushroom', 'oak_tree', 'orange', 'orchid', 'otter', 'palm_tree',
    'pear', 'pickup_truck', 'pine_tree', 'plain', 'plate', 'poppy',
    'porcupine', 'possum', 'rabbit', 'raccoon', 'ray', 'road', 'rocket',
    'rose', 'sea', 'seal', 'shark', 'shrew', 'skunk', 'skyscraper', 'snail',
    'snake', 'spider', 'squirrel', 'streetcar', 'sunflower', 'sweet_pepper',
    'table', 'tank', 'telephone', 'television', 'tiger', 'tractor', 'train',
    'trout', 'tulip', 'turtle', 'wardrobe', 'whale', 'willow_tree', 'wolf',
    'woman', 'worm')

MNIST_CATEGORITES = ('0 - zero', '1 - one', '2 - two', '3 - three', '4 - four',
                     '5 - five', '6 - six', '7 - seven', '8 - eight',
                     '9 - nine')

FASHIONMNIST_CATEGORITES = ('T-shirt/top', 'Trouser', 'Pullover', 'Dress',
                            'Coat', 'Sandal', 'Shirt', 'Sneaker', 'Bag',
                            'Ankle boot')

PLACES205_CATEGORIES = (
    'abbey', 'airport_terminal', 'alley', 'amphitheater', 'amusement_park',
    'aquarium', 'aqueduct', 'arch', 'art_gallery', 'art_studio',
    'assembly_line', 'attic', 'auditorium', 'apartment_building/outdoor',
    'badlands', 'ballroom', 'bamboo_forest', 'banquet_hall', 'bar',
    'baseball_field', 'basement', 'basilica', 'bayou', 'beauty_salon',
    'bedroom', 'boardwalk', 'boat_deck', 'bookstore', 'botanical_garden',
    'bowling_alley', 'boxing_ring', 'bridge', 'building_facade',
    'bus_interior', 'butchers_shop', 'butte', 'bakery/shop', 'cafeteria',
    'campsite', 'candy_store', 'canyon', 'castle', 'cemetery', 'chalet',
    'classroom', 'closet', 'clothing_store', 'coast', 'cockpit', 'coffee_shop',
    'conference_center', 'conference_room', 'construction_site', 'corn_field',
    'corridor', 'cottage_garden', 'courthouse', 'courtyard', 'creek',
    'crevasse', 'crosswalk', 'cathedral/outdoor', 'church/outdoor', 'dam',
    'dining_room', 'dock', 'dorm_room', 'driveway', 'desert/sand',
    'desert/vegetation', 'dinette/home', 'doorway/outdoor', 'engine_room',
    'excavation', 'fairway', 'fire_escape', 'fire_station', 'food_court',
    'forest_path', 'forest_road', 'formal_garden', 'fountain',
    'field/cultivated', 'field/wild', 'galley', 'game_room', 'garbage_dump',
    'gas_station', 'gift_shop', 'golf_course', 'harbor', 'herb_garden',
    'highway', 'home_office', 'hospital', 'hospital_room', 'hot_spring',
    'hotel_room', 'hotel/outdoor', 'ice_cream_parlor', 'iceberg', 'igloo',
    'islet', 'ice_skating_rink/outdoor', 'inn/outdoor', 'jail_cell', 'kasbah',
    'kindergarden_classroom', 'kitchen', 'kitchenette', 'laundromat',
    'lighthouse', 'living_room', 'lobby', 'locker_room', 'mansion', 'marsh',
    'martial_arts_gym', 'mausoleum', 'medina', 'motel', 'mountain',
    'mountain_snowy', 'music_studio', 'market/outdoor', 'monastery/outdoor',
    'museum/indoor', 'nursery', 'ocean', 'office', 'office_building',
    'orchard', 'pagoda', 'palace', 'pantry', 'parking_lot', 'parlor',
    'pasture', 'patio', 'pavilion', 'phone_booth', 'picnic_area', 'playground',
    'plaza', 'pond', 'pulpit', 'racecourse', 'raft', 'railroad_track',
    'rainforest', 'reception', 'residential_neighborhood', 'restaurant',
    'restaurant_kitchen', 'restaurant_patio', 'rice_paddy', 'river',
    'rock_arch', 'rope_bridge', 'ruin', 'runway', 'sandbar', 'schoolhouse',
    'sea_cliff', 'shed', 'shoe_shop', 'shopfront', 'shower', 'ski_resort',
    'ski_slope', 'sky', 'skyscraper', 'slum', 'snowfield', 'staircase',
    'supermarket', 'swamp', 'stadium/baseball', 'stadium/football',
    'stage/indoor', 'subway_station/platform', 'swimming_pool/outdoor',
    'television_studio', 'topiary_garden', 'tower', 'train_railway',
    'tree_farm', 'trench', 'temple/east_asia', 'temple/south_asia',
    'track/outdoor', 'train_station/platform', 'underwater/coral_reef',
    'valley', 'vegetable_garden', 'veranda', 'viaduct', 'volcano',
    'waiting_room', 'water_tower', 'watering_hole', 'wheat_field', 'wind_farm',
    'windmill', 'yard')

OxfordIIITPet_CATEGORIES = (
    'Abyssinian', 'american_bulldog', 'american_pit_bull_terrier',
    'basset_hound', 'beagle', 'Bengal', 'Birman', 'Bombay', 'boxer',
    'British_Shorthair', 'chihuahua', 'Egyptian_Mau', 'english_cocker_spaniel',
    'english_setter', 'german_shorthaired', 'great_pyrenees', 'havanese',
    'japanese_chin', 'keeshond', 'leonberger', 'Maine_Coon',
    'miniature_pinscher', 'newfoundland', 'Persian', 'pomeranian', 'pug',
    'Ragdoll', 'Russian_Blue', 'saint_bernard', 'samoyed', 'scottish_terrier',
    'shiba_inu', 'Siamese', 'Sphynx', 'staffordshire_bull_terrier',
    'wheaten_terrier', 'yorkshire_terrier')

DTD_CATEGORIES = ('banded', 'blotchy', 'braided', 'bubbly', 'bumpy',
                  'chequered', 'cobwebbed', 'cracked', 'crosshatched',
                  'crystalline', 'dotted', 'fibrous', 'flecked', 'freckled',
                  'frilly', 'gauzy', 'grid', 'grooved', 'honeycombed',
                  'interlaced', 'knitted', 'lacelike', 'lined', 'marbled',
                  'matted', 'meshed', 'paisley', 'perforated', 'pitted',
                  'pleated', 'polka-dotted', 'porous', 'potholed', 'scaly',
                  'smeared', 'spiralled', 'sprinkled', 'stained', 'stratified',
                  'striped', 'studded', 'swirly', 'veined', 'waffled', 'woven',
                  'wrinkled', 'zigzagged')

FGVCAIRCRAFT_CATEGORIES = (
    '707-320', '727-200', '737-200', '737-300', '737-400', '737-500',
    '737-600', '737-700', '737-800', '737-900', '747-100', '747-200',
    '747-300', '747-400', '757-200', '757-300', '767-200', '767-300',
    '767-400', '777-200', '777-300', 'A300B4', 'A310', 'A318', 'A319', 'A320',
    'A321', 'A330-200', 'A330-300', 'A340-200', 'A340-300', 'A340-500',
    'A340-600', 'A380', 'ATR-42', 'ATR-72', 'An-12', 'BAE 146-200',
    'BAE 146-300', 'BAE-125', 'Beechcraft 1900', 'Boeing 717', 'C-130', 'C-47',
    'CRJ-200', 'CRJ-700', 'CRJ-900', 'Cessna 172', 'Cessna 208', 'Cessna 525',
    'Cessna 560', 'Challenger 600', 'DC-10', 'DC-3', 'DC-6', 'DC-8', 'DC-9-30',
    'DH-82', 'DHC-1', 'DHC-6', 'DHC-8-100', 'DHC-8-300', 'DR-400',
    'Dornier 328', 'E-170', 'E-190', 'E-195', 'EMB-120', 'ERJ 135', 'ERJ 145',
    'Embraer Legacy 600', 'Eurofighter Typhoon', 'F-16A/B', 'F/A-18',
    'Falcon 2000', 'Falcon 900', 'Fokker 100', 'Fokker 50', 'Fokker 70',
    'Global Express', 'Gulfstream IV', 'Gulfstream V', 'Hawk T1', 'Il-76',
    'L-1011', 'MD-11', 'MD-80', 'MD-87', 'MD-90', 'Metroliner', 'Model B200',
    'PA-28', 'SR-20', 'Saab 2000', 'Saab 340', 'Spitfire', 'Tornado', 'Tu-134',
    'Tu-154', 'Yak-42')

STANFORDCARS_CATEGORIES = (
    'AM General Hummer SUV 2000', 'Acura RL Sedan 2012', 'Acura TL Sedan 2012',
    'Acura TL Type-S 2008', 'Acura TSX Sedan 2012',
    'Acura Integra Type R 2001', 'Acura ZDX Hatchback 2012',
    'Aston Martin V8 Vantage Convertible 2012',
    'Aston Martin V8 Vantage Coupe 2012',
    'Aston Martin Virage Convertible 2012', 'Aston Martin Virage Coupe 2012',
    'Audi RS 4 Convertible 2008', 'Audi A5 Coupe 2012', 'Audi TTS Coupe 2012',
    'Audi R8 Coupe 2012', 'Audi V8 Sedan 1994', 'Audi 100 Sedan 1994',
    'Audi 100 Wagon 1994', 'Audi TT Hatchback 2011', 'Audi S6 Sedan 2011',
    'Audi S5 Convertible 2012', 'Audi S5 Coupe 2012', 'Audi S4 Sedan 2012',
    'Audi S4 Sedan 2007', 'Audi TT RS Coupe 2012',
    'BMW ActiveHybrid 5 Sedan 2012', 'BMW 1 Series Convertible 2012',
    'BMW 1 Series Coupe 2012', 'BMW 3 Series Sedan 2012',
    'BMW 3 Series Wagon 2012', 'BMW 6 Series Convertible 2007',
    'BMW X5 SUV 2007', 'BMW X6 SUV 2012', 'BMW M3 Coupe 2012',
    'BMW M5 Sedan 2010', 'BMW M6 Convertible 2010', 'BMW X3 SUV 2012',
    'BMW Z4 Convertible 2012',
    'Bentley Continental Supersports Conv. Convertible 2012',
    'Bentley Arnage Sedan 2009', 'Bentley Mulsanne Sedan 2011',
    'Bentley Continental GT Coupe 2012', 'Bentley Continental GT Coupe 2007',
    'Bentley Continental Flying Spur Sedan 2007',
    'Bugatti Veyron 16.4 Convertible 2009', 'Bugatti Veyron 16.4 Coupe 2009',
    'Buick Regal GS 2012', 'Buick Rainier SUV 2007', 'Buick Verano Sedan 2012',
    'Buick Enclave SUV 2012', 'Cadillac CTS-V Sedan 2012',
    'Cadillac SRX SUV 2012', 'Cadillac Escalade EXT Crew Cab 2007',
    'Chevrolet Silverado 1500 Hybrid Crew Cab 2012',
    'Chevrolet Corvette Convertible 2012', 'Chevrolet Corvette ZR1 2012',
    'Chevrolet Corvette Ron Fellows Edition Z06 2007',
    'Chevrolet Traverse SUV 2012', 'Chevrolet Camaro Convertible 2012',
    'Chevrolet HHR SS 2010', 'Chevrolet Impala Sedan 2007',
    'Chevrolet Tahoe Hybrid SUV 2012', 'Chevrolet Sonic Sedan 2012',
    'Chevrolet Express Cargo Van 2007', 'Chevrolet Avalanche Crew Cab 2012',
    'Chevrolet Cobalt SS 2010', 'Chevrolet Malibu Hybrid Sedan 2010',
    'Chevrolet TrailBlazer SS 2009',
    'Chevrolet Silverado 2500HD Regular Cab 2012',
    'Chevrolet Silverado 1500 Classic Extended Cab 2007',
    'Chevrolet Express Van 2007', 'Chevrolet Monte Carlo Coupe 2007',
    'Chevrolet Malibu Sedan 2007',
    'Chevrolet Silverado 1500 Extended Cab 2012',
    'Chevrolet Silverado 1500 Regular Cab 2012', 'Chrysler Aspen SUV 2009',
    'Chrysler Sebring Convertible 2010',
    'Chrysler Town and Country Minivan 2012', 'Chrysler 300 SRT-8 2010',
    'Chrysler Crossfire Convertible 2008',
    'Chrysler PT Cruiser Convertible 2008', 'Daewoo Nubira Wagon 2002',
    'Dodge Caliber Wagon 2012', 'Dodge Caliber Wagon 2007',
    'Dodge Caravan Minivan 1997', 'Dodge Ram Pickup 3500 Crew Cab 2010',
    'Dodge Ram Pickup 3500 Quad Cab 2009', 'Dodge Sprinter Cargo Van 2009',
    'Dodge Journey SUV 2012', 'Dodge Dakota Crew Cab 2010',
    'Dodge Dakota Club Cab 2007', 'Dodge Magnum Wagon 2008',
    'Dodge Challenger SRT8 2011', 'Dodge Durango SUV 2012',
    'Dodge Durango SUV 2007', 'Dodge Charger Sedan 2012',
    'Dodge Charger SRT-8 2009', 'Eagle Talon Hatchback 1998',
    'FIAT 500 Abarth 2012', 'FIAT 500 Convertible 2012',
    'Ferrari FF Coupe 2012', 'Ferrari California Convertible 2012',
    'Ferrari 458 Italia Convertible 2012', 'Ferrari 458 Italia Coupe 2012',
    'Fisker Karma Sedan 2012', 'Ford F-450 Super Duty Crew Cab 2012',
    'Ford Mustang Convertible 2007', 'Ford Freestar Minivan 2007',
    'Ford Expedition EL SUV 2009', 'Ford Edge SUV 2012',
    'Ford Ranger SuperCab 2011', 'Ford GT Coupe 2006',
    'Ford F-150 Regular Cab 2012', 'Ford F-150 Regular Cab 2007',
    'Ford Focus Sedan 2007', 'Ford E-Series Wagon Van 2012',
    'Ford Fiesta Sedan 2012', 'GMC Terrain SUV 2012', 'GMC Savana Van 2012',
    'GMC Yukon Hybrid SUV 2012', 'GMC Acadia SUV 2012',
    'GMC Canyon Extended Cab 2012', 'Geo Metro Convertible 1993',
    'HUMMER H3T Crew Cab 2010', 'HUMMER H2 SUT Crew Cab 2009',
    'Honda Odyssey Minivan 2012', 'Honda Odyssey Minivan 2007',
    'Honda Accord Coupe 2012', 'Honda Accord Sedan 2012',
    'Hyundai Veloster Hatchback 2012', 'Hyundai Santa Fe SUV 2012',
    'Hyundai Tucson SUV 2012', 'Hyundai Veracruz SUV 2012',
    'Hyundai Sonata Hybrid Sedan 2012', 'Hyundai Elantra Sedan 2007',
    'Hyundai Accent Sedan 2012', 'Hyundai Genesis Sedan 2012',
    'Hyundai Sonata Sedan 2012', 'Hyundai Elantra Touring Hatchback 2012',
    'Hyundai Azera Sedan 2012', 'Infiniti G Coupe IPL 2012',
    'Infiniti QX56 SUV 2011', 'Isuzu Ascender SUV 2008', 'Jaguar XK XKR 2012',
    'Jeep Patriot SUV 2012', 'Jeep Wrangler SUV 2012', 'Jeep Liberty SUV 2012',
    'Jeep Grand Cherokee SUV 2012', 'Jeep Compass SUV 2012',
    'Lamborghini Reventon Coupe 2008', 'Lamborghini Aventador Coupe 2012',
    'Lamborghini Gallardo LP 570-4 Superleggera 2012',
    'Lamborghini Diablo Coupe 2001', 'Land Rover Range Rover SUV 2012',
    'Land Rover LR2 SUV 2012', 'Lincoln Town Car Sedan 2011',
    'MINI Cooper Roadster Convertible 2012',
    'Maybach Landaulet Convertible 2012', 'Mazda Tribute SUV 2011',
    'McLaren MP4-12C Coupe 2012', 'Mercedes-Benz 300-Class Convertible 1993',
    'Mercedes-Benz C-Class Sedan 2012', 'Mercedes-Benz SL-Class Coupe 2009',
    'Mercedes-Benz E-Class Sedan 2012', 'Mercedes-Benz S-Class Sedan 2012',
    'Mercedes-Benz Sprinter Van 2012', 'Mitsubishi Lancer Sedan 2012',
    'Nissan Leaf Hatchback 2012', 'Nissan NV Passenger Van 2012',
    'Nissan Juke Hatchback 2012', 'Nissan 240SX Coupe 1998',
    'Plymouth Neon Coupe 1999', 'Porsche Panamera Sedan 2012',
    'Ram C/V Cargo Van Minivan 2012',
    'Rolls-Royce Phantom Drophead Coupe Convertible 2012',
    'Rolls-Royce Ghost Sedan 2012', 'Rolls-Royce Phantom Sedan 2012',
    'Scion xD Hatchback 2012', 'Spyker C8 Convertible 2009',
    'Spyker C8 Coupe 2009', 'Suzuki Aerio Sedan 2007',
    'Suzuki Kizashi Sedan 2012', 'Suzuki SX4 Hatchback 2012',
    'Suzuki SX4 Sedan 2012', 'Tesla Model S Sedan 2012',
    'Toyota Sequoia SUV 2012', 'Toyota Camry Sedan 2012',
    'Toyota Corolla Sedan 2012', 'Toyota 4Runner SUV 2012',
    'Volkswagen Golf Hatchback 2012', 'Volkswagen Golf Hatchback 1991',
    'Volkswagen Beetle Hatchback 2012', 'Volvo C30 Hatchback 2012',
    'Volvo 240 Sedan 1993', 'Volvo XC90 SUV 2007',
    'smart fortwo Convertible 2012')

SUN397_CATEGORIES = (
    'abbey', 'airplane_cabin', 'airport_terminal', 'alley', 'amphitheater',
    'amusement_arcade', 'amusement_park', 'anechoic_chamber',
    'apartment_building_outdoor', 'apse_indoor', 'aquarium', 'aqueduct',
    'arch', 'archive', 'arrival_gate_outdoor', 'art_gallery', 'art_school',
    'art_studio', 'assembly_line', 'athletic_field_outdoor', 'atrium_public',
    'attic', 'auditorium', 'auto_factory', 'badlands',
    'badminton_court_indoor', 'baggage_claim', 'bakery_shop',
    'balcony_exterior', 'balcony_interior', 'ball_pit', 'ballroom',
    'bamboo_forest', 'banquet_hall', 'bar', 'barn', 'barndoor',
    'baseball_field', 'basement', 'basilica', 'basketball_court_outdoor',
    'bathroom', 'batters_box', 'bayou', 'bazaar_indoor', 'bazaar_outdoor',
    'beach', 'beauty_salon', 'bedroom', 'berth', 'biology_laboratory',
    'bistro_indoor', 'boardwalk', 'boat_deck', 'boathouse', 'bookstore',
    'booth_indoor', 'botanical_garden', 'bow_window_indoor',
    'bow_window_outdoor', 'bowling_alley', 'boxing_ring', 'brewery_indoor',
    'bridge', 'building_facade', 'bullring', 'burial_chamber', 'bus_interior',
    'butchers_shop', 'butte', 'cabin_outdoor', 'cafeteria', 'campsite',
    'campus', 'canal_natural', 'canal_urban', 'candy_store', 'canyon',
    'car_interior_backseat', 'car_interior_frontseat', 'carrousel',
    'casino_indoor', 'castle', 'catacomb', 'cathedral_indoor',
    'cathedral_outdoor', 'cavern_indoor', 'cemetery', 'chalet',
    'cheese_factory', 'chemistry_lab', 'chicken_coop_indoor',
    'chicken_coop_outdoor', 'childs_room', 'church_indoor', 'church_outdoor',
    'classroom', 'clean_room', 'cliff', 'cloister_indoor', 'closet',
    'clothing_store', 'coast', 'cockpit', 'coffee_shop', 'computer_room',
    'conference_center', 'conference_room', 'construction_site',
    'control_room', 'control_tower_outdoor', 'corn_field', 'corral',
    'corridor', 'cottage_garden', 'courthouse', 'courtroom', 'courtyard',
    'covered_bridge_exterior', 'creek', 'crevasse', 'crosswalk',
    'cubicle_office', 'dam', 'delicatessen', 'dentists_office', 'desert_sand',
    'desert_vegetation', 'diner_indoor', 'diner_outdoor', 'dinette_home',
    'dinette_vehicle', 'dining_car', 'dining_room', 'discotheque', 'dock',
    'doorway_outdoor', 'dorm_room', 'driveway', 'driving_range_outdoor',
    'drugstore', 'electrical_substation', 'elevator_door', 'elevator_interior',
    'elevator_shaft', 'engine_room', 'escalator_indoor', 'excavation',
    'factory_indoor', 'fairway', 'fastfood_restaurant', 'field_cultivated',
    'field_wild', 'fire_escape', 'fire_station', 'firing_range_indoor',
    'fishpond', 'florist_shop_indoor', 'food_court', 'forest_broadleaf',
    'forest_needleleaf', 'forest_path', 'forest_road', 'formal_garden',
    'fountain', 'galley', 'game_room', 'garage_indoor', 'garbage_dump',
    'gas_station', 'gazebo_exterior', 'general_store_indoor',
    'general_store_outdoor', 'gift_shop', 'golf_course', 'greenhouse_indoor',
    'greenhouse_outdoor', 'gymnasium_indoor', 'hangar_indoor',
    'hangar_outdoor', 'harbor', 'hayfield', 'heliport', 'herb_garden',
    'highway', 'hill', 'home_office', 'hospital', 'hospital_room',
    'hot_spring', 'hot_tub_outdoor', 'hotel_outdoor', 'hotel_room', 'house',
    'hunting_lodge_outdoor', 'ice_cream_parlor', 'ice_floe', 'ice_shelf',
    'ice_skating_rink_indoor', 'ice_skating_rink_outdoor', 'iceberg', 'igloo',
    'industrial_area', 'inn_outdoor', 'islet', 'jacuzzi_indoor', 'jail_indoor',
    'jail_cell', 'jewelry_shop', 'kasbah', 'kennel_indoor', 'kennel_outdoor',
    'kindergarden_classroom', 'kitchen', 'kitchenette', 'labyrinth_outdoor',
    'lake_natural', 'landfill', 'landing_deck', 'laundromat', 'lecture_room',
    'library_indoor', 'library_outdoor', 'lido_deck_outdoor', 'lift_bridge',
    'lighthouse', 'limousine_interior', 'living_room', 'lobby', 'lock_chamber',
    'locker_room', 'mansion', 'manufactured_home', 'market_indoor',
    'market_outdoor', 'marsh', 'martial_arts_gym', 'mausoleum', 'medina',
    'moat_water', 'monastery_outdoor', 'mosque_indoor', 'mosque_outdoor',
    'motel', 'mountain', 'mountain_snowy', 'movie_theater_indoor',
    'museum_indoor', 'music_store', 'music_studio',
    'nuclear_power_plant_outdoor', 'nursery', 'oast_house',
    'observatory_outdoor', 'ocean', 'office', 'office_building',
    'oil_refinery_outdoor', 'oilrig', 'operating_room', 'orchard',
    'outhouse_outdoor', 'pagoda', 'palace', 'pantry', 'park',
    'parking_garage_indoor', 'parking_garage_outdoor', 'parking_lot', 'parlor',
    'pasture', 'patio', 'pavilion', 'pharmacy', 'phone_booth',
    'physics_laboratory', 'picnic_area', 'pilothouse_indoor',
    'planetarium_outdoor', 'playground', 'playroom', 'plaza', 'podium_indoor',
    'podium_outdoor', 'pond', 'poolroom_establishment', 'poolroom_home',
    'power_plant_outdoor', 'promenade_deck', 'pub_indoor', 'pulpit',
    'putting_green', 'racecourse', 'raceway', 'raft', 'railroad_track',
    'rainforest', 'reception', 'recreation_room', 'residential_neighborhood',
    'restaurant', 'restaurant_kitchen', 'restaurant_patio', 'rice_paddy',
    'riding_arena', 'river', 'rock_arch', 'rope_bridge', 'ruin', 'runway',
    'sandbar', 'sandbox', 'sauna', 'schoolhouse', 'sea_cliff', 'server_room',
    'shed', 'shoe_shop', 'shopfront', 'shopping_mall_indoor', 'shower',
    'skatepark', 'ski_lodge', 'ski_resort', 'ski_slope', 'sky', 'skyscraper',
    'slum', 'snowfield', 'squash_court', 'stable', 'stadium_baseball',
    'stadium_football', 'stage_indoor', 'staircase', 'street',
    'subway_interior', 'subway_station_platform', 'supermarket', 'sushi_bar',
    'swamp', 'swimming_pool_indoor', 'swimming_pool_outdoor',
    'synagogue_indoor', 'synagogue_outdoor', 'television_studio',
    'temple_east_asia', 'temple_south_asia', 'tennis_court_indoor',
    'tennis_court_outdoor', 'tent_outdoor', 'theater_indoor_procenium',
    'theater_indoor_seats', 'thriftshop', 'throne_room', 'ticket_booth',
    'toll_plaza', 'topiary_garden', 'tower', 'toyshop', 'track_outdoor',
    'train_railway', 'train_station_platform', 'tree_farm', 'tree_house',
    'trench', 'underwater_coral_reef', 'utility_room', 'valley',
    'van_interior', 'vegetable_garden', 'veranda', 'veterinarians_office',
    'viaduct', 'videostore', 'village', 'vineyard', 'volcano',
    'volleyball_court_indoor', 'volleyball_court_outdoor', 'waiting_room',
    'warehouse_indoor', 'water_tower', 'waterfall_block', 'waterfall_fan',
    'waterfall_plunge', 'watering_hole', 'wave', 'wet_bar', 'wheat_field',
    'wind_farm', 'windmill', 'wine_cellar_barrel_storage',
    'wine_cellar_bottle_storage', 'wrestling_ring_indoor', 'yard',
    'youth_hostel')

CALTECH101_CATEGORIES = (
    'BACKGROUND_Google', 'Faces', 'Faces_easy', 'Leopards', 'Motorbikes',
    'accordion', 'airplanes', 'anchor', 'ant', 'barrel', 'bass', 'beaver',
    'binocular', 'bonsai', 'brain', 'brontosaurus', 'buddha', 'butterfly',
    'camera', 'cannon', 'car_side', 'ceiling_fan', 'cellphone', 'chair',
    'chandelier', 'cougar_body', 'cougar_face', 'crab', 'crayfish',
    'crocodile', 'crocodile_head', 'cup', 'dalmatian', 'dollar_bill',
    'dolphin', 'dragonfly', 'electric_guitar', 'elephant', 'emu', 'euphonium',
    'ewer', 'ferry', 'flamingo', 'flamingo_head', 'garfield', 'gerenuk',
    'gramophone', 'grand_piano', 'hawksbill', 'headphone', 'hedgehog',
    'helicopter', 'ibis', 'inline_skate', 'joshua_tree', 'kangaroo', 'ketch',
    'lamp', 'laptop', 'llama', 'lobster', 'lotus', 'mandolin', 'mayfly',
    'menorah', 'metronome', 'minaret', 'nautilus', 'octopus', 'okapi',
    'pagoda', 'panda', 'pigeon', 'pizza', 'platypus', 'pyramid', 'revolver',
    'rhino', 'rooster', 'saxophone', 'schooner', 'scissors', 'scorpion',
    'sea_horse', 'snoopy', 'soccer_ball', 'stapler', 'starfish', 'stegosaurus',
    'stop_sign', 'strawberry', 'sunflower', 'tick', 'trilobite', 'umbrella',
    'watch', 'water_lilly', 'wheelchair', 'wild_cat', 'windsor_chair',
    'wrench', 'yin_yang')

FOOD101_CATEGORIES = (
    'apple_pie', 'baby_back_ribs', 'baklava', 'beef_carpaccio', 'beef_tartare',
    'beet_salad', 'beignets', 'bibimbap', 'bread_pudding', 'breakfast_burrito',
    'bruschetta', 'caesar_salad', 'cannoli', 'caprese_salad', 'carrot_cake',
    'ceviche', 'cheesecake', 'cheese_plate', 'chicken_curry',
    'chicken_quesadilla', 'chicken_wings', 'chocolate_cake',
    'chocolate_mousse', 'churros', 'clam_chowder', 'club_sandwich',
    'crab_cakes', 'creme_brulee', 'croque_madame', 'cup_cakes', 'deviled_eggs',
    'donuts', 'dumplings', 'edamame', 'eggs_benedict', 'escargots', 'falafel',
    'filet_mignon', 'fish_and_chips', 'foie_gras', 'french_fries',
    'french_onion_soup', 'french_toast', 'fried_calamari', 'fried_rice',
    'frozen_yogurt', 'garlic_bread', 'gnocchi', 'greek_salad',
    'grilled_cheese_sandwich', 'grilled_salmon', 'guacamole', 'gyoza',
    'hamburger', 'hot_and_sour_soup', 'hot_dog', 'huevos_rancheros', 'hummus',
    'ice_cream', 'lasagna', 'lobster_bisque', 'lobster_roll_sandwich',
    'macaroni_and_cheese', 'macarons', 'miso_soup', 'mussels', 'nachos',
    'omelette', 'onion_rings', 'oysters', 'pad_thai', 'paella', 'pancakes',
    'panna_cotta', 'peking_duck', 'pho', 'pizza', 'pork_chop', 'poutine',
    'prime_rib', 'pulled_pork_sandwich', 'ramen', 'ravioli', 'red_velvet_cake',
    'risotto', 'samosa', 'sashimi', 'scallops', 'seaweed_salad',
    'shrimp_and_grits', 'spaghetti_bolognese', 'spaghetti_carbonara',
    'spring_rolls', 'steak', 'strawberry_shortcake', 'sushi', 'tacos',
    'takoyaki', 'tiramisu', 'tuna_tartare', 'waffles')

CIFAR100_CATEGORIES_CN = (
    '苹果', '水族馆鱼', '婴儿', '熊', '河狸', '床', '蜜蜂', '甲虫', '自行车', '瓶子', '碗', '小男孩',
    '桥', '公共汽车', '蝴蝶', '骆驼', '易拉罐', '城堡', '毛毛虫', '牛', '椅子', '猩猩', '钟', '白云',
    '蟑螂', '沙发', '螃蟹', '鳄鱼', '杯子', '恐龙', '海豚', '大象', '比目鱼', '森林', '狐狸', '小女孩',
    '仓鼠', '屋子', '袋鼠', '键盘', '台灯', '割草机', '猎豹', '狮子', '蜥蜴', '龙虾', '男人', '枫树',
    '摩托车', '山', '老鼠', '蘑菇', '橡树', '橙子橘子', '兰花', '水獭', '棕榈树', '梨', '皮卡车', '松树',
    '田野', '盘子', '罂粟', '豪猪', '负鼠', '兔子', '浣熊', '鳐鱼', '公路', '火箭', '玫瑰', '大海',
    '海豹', '鲨鱼', '尖嘴小鼠', '臭鼬', '摩天大楼', '蜗牛', '蛇', '蜘蛛', '松鼠', '电车', '向日葵', '甜椒',
    '桌子', '坦克', '电话', '电视', '老虎', '拖拉机', '火车', '鳟鱼', '郁金香', '乌龟', '衣柜', '鲸鱼',
    '柳树', '狼', '女人', '蠕虫')

IMAGENET_SIMPLE_CATEGORIES = (
    'tench', 'goldfish', 'great white shark', 'tiger shark',
    'hammerhead shark', 'electric ray', 'stingray', 'rooster', 'hen',
    'ostrich', 'brambling', 'goldfinch', 'house finch', 'junco',
    'indigo bunting', 'American robin', 'bulbul', 'jay', 'magpie', 'chickadee',
    'American dipper', 'kite (bird of prey)', 'bald eagle', 'vulture',
    'great grey owl', 'fire salamander', 'smooth newt', 'newt',
    'spotted salamander', 'axolotl', 'American bullfrog', 'tree frog',
    'tailed frog', 'loggerhead sea turtle', 'leatherback sea turtle',
    'mud turtle', 'terrapin', 'box turtle', 'banded gecko', 'green iguana',
    'Carolina anole', 'desert grassland whiptail lizard', 'agama',
    'frilled-necked lizard', 'alligator lizard', 'Gila monster',
    'European green lizard', 'chameleon', 'Komodo dragon', 'Nile crocodile',
    'American alligator', 'triceratops', 'worm snake', 'ring-necked snake',
    'eastern hog-nosed snake', 'smooth green snake', 'kingsnake',
    'garter snake', 'water snake', 'vine snake', 'night snake',
    'boa constrictor', 'African rock python', 'Indian cobra', 'green mamba',
    'sea snake', 'Saharan horned viper', 'eastern diamondback rattlesnake',
    'sidewinder rattlesnake', 'trilobite', 'harvestman', 'scorpion',
    'yellow garden spider', 'barn spider', 'European garden spider',
    'southern black widow', 'tarantula', 'wolf spider', 'tick', 'centipede',
    'black grouse', 'ptarmigan', 'ruffed grouse', 'prairie grouse', 'peafowl',
    'quail', 'partridge', 'african grey parrot', 'macaw',
    'sulphur-crested cockatoo', 'lorikeet', 'coucal', 'bee eater', 'hornbill',
    'hummingbird', 'jacamar', 'toucan', 'duck', 'red-breasted merganser',
    'goose', 'black swan', 'tusker', 'echidna', 'platypus', 'wallaby', 'koala',
    'wombat', 'jellyfish', 'sea anemone', 'brain coral', 'flatworm',
    'nematode', 'conch', 'snail', 'slug', 'sea slug', 'chiton',
    'chambered nautilus', 'Dungeness crab', 'rock crab', 'fiddler crab',
    'red king crab', 'American lobster', 'spiny lobster', 'crayfish',
    'hermit crab', 'isopod', 'white stork', 'black stork', 'spoonbill',
    'flamingo', 'little blue heron', 'great egret', 'bittern bird',
    'crane bird', 'limpkin', 'common gallinule', 'American coot', 'bustard',
    'ruddy turnstone', 'dunlin', 'common redshank', 'dowitcher',
    'oystercatcher', 'pelican', 'king penguin', 'albatross', 'grey whale',
    'killer whale', 'dugong', 'sea lion', 'Chihuahua', 'Japanese Chin',
    'Maltese', 'Pekingese', 'Shih Tzu', 'King Charles Spaniel', 'Papillon',
    'toy terrier', 'Rhodesian Ridgeback', 'Afghan Hound', 'Basset Hound',
    'Beagle', 'Bloodhound', 'Bluetick Coonhound', 'Black and Tan Coonhound',
    'Treeing Walker Coonhound', 'English foxhound', 'Redbone Coonhound',
    'borzoi', 'Irish Wolfhound', 'Italian Greyhound', 'Whippet',
    'Ibizan Hound', 'Norwegian Elkhound', 'Otterhound', 'Saluki',
    'Scottish Deerhound', 'Weimaraner', 'Staffordshire Bull Terrier',
    'American Staffordshire Terrier', 'Bedlington Terrier', 'Border Terrier',
    'Kerry Blue Terrier', 'Irish Terrier', 'Norfolk Terrier',
    'Norwich Terrier', 'Yorkshire Terrier', 'Wire Fox Terrier',
    'Lakeland Terrier', 'Sealyham Terrier', 'Airedale Terrier',
    'Cairn Terrier', 'Australian Terrier', 'Dandie Dinmont Terrier',
    'Boston Terrier', 'Miniature Schnauzer', 'Giant Schnauzer',
    'Standard Schnauzer', 'Scottish Terrier', 'Tibetan Terrier',
    'Australian Silky Terrier', 'Soft-coated Wheaten Terrier',
    'West Highland White Terrier', 'Lhasa Apso', 'Flat-Coated Retriever',
    'Curly-coated Retriever', 'Golden Retriever', 'Labrador Retriever',
    'Chesapeake Bay Retriever', 'German Shorthaired Pointer', 'Vizsla',
    'English Setter', 'Irish Setter', 'Gordon Setter', 'Brittany dog',
    'Clumber Spaniel', 'English Springer Spaniel', 'Welsh Springer Spaniel',
    'Cocker Spaniel', 'Sussex Spaniel', 'Irish Water Spaniel', 'Kuvasz',
    'Schipperke', 'Groenendael dog', 'Malinois', 'Briard', 'Australian Kelpie',
    'Komondor', 'Old English Sheepdog', 'Shetland Sheepdog', 'collie',
    'Border Collie', 'Bouvier des Flandres dog', 'Rottweiler',
    'German Shepherd Dog', 'Dobermann', 'Miniature Pinscher',
    'Greater Swiss Mountain Dog', 'Bernese Mountain Dog',
    'Appenzeller Sennenhund', 'Entlebucher Sennenhund', 'Boxer', 'Bullmastiff',
    'Tibetan Mastiff', 'French Bulldog', 'Great Dane', 'St. Bernard', 'husky',
    'Alaskan Malamute', 'Siberian Husky', 'Dalmatian', 'Affenpinscher',
    'Basenji', 'pug', 'Leonberger', 'Newfoundland dog', 'Great Pyrenees dog',
    'Samoyed', 'Pomeranian', 'Chow Chow', 'Keeshond', 'brussels griffon',
    'Pembroke Welsh Corgi', 'Cardigan Welsh Corgi', 'Toy Poodle',
    'Miniature Poodle', 'Standard Poodle',
    'Mexican hairless dog (xoloitzcuintli)', 'grey wolf',
    'Alaskan tundra wolf', 'red wolf or maned wolf', 'coyote', 'dingo',
    'dhole', 'African wild dog', 'hyena', 'red fox', 'kit fox', 'Arctic fox',
    'grey fox', 'tabby cat', 'tiger cat', 'Persian cat', 'Siamese cat',
    'Egyptian Mau', 'cougar', 'lynx', 'leopard', 'snow leopard', 'jaguar',
    'lion', 'tiger', 'cheetah', 'brown bear', 'American black bear',
    'polar bear', 'sloth bear', 'mongoose', 'meerkat', 'tiger beetle',
    'ladybug', 'ground beetle', 'longhorn beetle', 'leaf beetle',
    'dung beetle', 'rhinoceros beetle', 'weevil', 'fly', 'bee', 'ant',
    'grasshopper', 'cricket insect', 'stick insect', 'cockroach',
    'praying mantis', 'cicada', 'leafhopper', 'lacewing', 'dragonfly',
    'damselfly', 'red admiral butterfly', 'ringlet butterfly',
    'monarch butterfly', 'small white butterfly', 'sulphur butterfly',
    'gossamer-winged butterfly', 'starfish', 'sea urchin', 'sea cucumber',
    'cottontail rabbit', 'hare', 'Angora rabbit', 'hamster', 'porcupine',
    'fox squirrel', 'marmot', 'beaver', 'guinea pig', 'common sorrel horse',
    'zebra', 'pig', 'wild boar', 'warthog', 'hippopotamus', 'ox',
    'water buffalo', 'bison', 'ram (adult male sheep)', 'bighorn sheep',
    'Alpine ibex', 'hartebeest', 'impala (antelope)', 'gazelle',
    'arabian camel', 'llama', 'weasel', 'mink', 'European polecat',
    'black-footed ferret', 'otter', 'skunk', 'badger', 'armadillo',
    'three-toed sloth', 'orangutan', 'gorilla', 'chimpanzee', 'gibbon',
    'siamang', 'guenon', 'patas monkey', 'baboon', 'macaque', 'langur',
    'black-and-white colobus', 'proboscis monkey', 'marmoset',
    'white-headed capuchin', 'howler monkey', 'titi monkey',
    "Geoffroy's spider monkey", 'common squirrel monkey', 'ring-tailed lemur',
    'indri', 'Asian elephant', 'African bush elephant', 'red panda',
    'giant panda', 'snoek fish', 'eel', 'silver salmon', 'rock beauty fish',
    'clownfish', 'sturgeon', 'gar fish', 'lionfish', 'pufferfish', 'abacus',
    'abaya', 'academic gown', 'accordion', 'acoustic guitar',
    'aircraft carrier', 'airliner', 'airship', 'altar', 'ambulance',
    'amphibious vehicle', 'analog clock', 'apiary', 'apron', 'trash can',
    'assault rifle', 'backpack', 'bakery', 'balance beam', 'balloon',
    'ballpoint pen', 'Band-Aid', 'banjo', 'baluster / handrail', 'barbell',
    'barber chair', 'barbershop', 'barn', 'barometer', 'barrel', 'wheelbarrow',
    'baseball', 'basketball', 'bassinet', 'bassoon', 'swimming cap',
    'bath towel', 'bathtub', 'station wagon', 'lighthouse', 'beaker',
    'military hat (bearskin or shako)', 'beer bottle', 'beer glass',
    'bell tower', 'baby bib', 'tandem bicycle', 'bikini', 'ring binder',
    'binoculars', 'birdhouse', 'boathouse', 'bobsleigh', 'bolo tie',
    'poke bonnet', 'bookcase', 'bookstore', 'bottle cap', 'hunting bow',
    'bow tie', 'brass memorial plaque', 'bra', 'breakwater', 'breastplate',
    'broom', 'bucket', 'buckle', 'bulletproof vest', 'high-speed train',
    'butcher shop', 'taxicab', 'cauldron', 'candle', 'cannon', 'canoe',
    'can opener', 'cardigan', 'car mirror', 'carousel', 'tool kit',
    'cardboard box / carton', 'car wheel', 'automated teller machine',
    'cassette', 'cassette player', 'castle', 'catamaran', 'CD player', 'cello',
    'mobile phone', 'chain', 'chain-link fence', 'chain mail', 'chainsaw',
    'storage chest', 'chiffonier', 'bell or wind chime', 'china cabinet',
    'Christmas stocking', 'church', 'movie theater', 'cleaver',
    'cliff dwelling', 'cloak', 'clogs', 'cocktail shaker', 'coffee mug',
    'coffeemaker', 'spiral or coil', 'combination lock', 'computer keyboard',
    'candy store', 'container ship', 'convertible', 'corkscrew', 'cornet',
    'cowboy boot', 'cowboy hat', 'cradle', 'construction crane',
    'crash helmet', 'crate', 'infant bed', 'Crock Pot', 'croquet ball',
    'crutch', 'cuirass', 'dam', 'desk', 'desktop computer',
    'rotary dial telephone', 'diaper', 'digital clock', 'digital watch',
    'dining table', 'dishcloth', 'dishwasher', 'disc brake', 'dock',
    'dog sled', 'dome', 'doormat', 'drilling rig', 'drum', 'drumstick',
    'dumbbell', 'Dutch oven', 'electric fan', 'electric guitar',
    'electric locomotive', 'entertainment center', 'envelope',
    'espresso machine', 'face powder', 'feather boa', 'filing cabinet',
    'fireboat', 'fire truck', 'fire screen', 'flagpole', 'flute',
    'folding chair', 'football helmet', 'forklift', 'fountain', 'fountain pen',
    'four-poster bed', 'freight car', 'French horn', 'frying pan', 'fur coat',
    'garbage truck', 'gas mask or respirator', 'gas pump', 'goblet', 'go-kart',
    'golf ball', 'golf cart', 'gondola', 'gong', 'gown', 'grand piano',
    'greenhouse', 'radiator grille', 'grocery store', 'guillotine',
    'hair clip', 'hair spray', 'half-track', 'hammer', 'hamper', 'hair dryer',
    'hand-held computer', 'handkerchief', 'hard disk drive', 'harmonica',
    'harp', 'combine harvester', 'hatchet', 'holster', 'home theater',
    'honeycomb', 'hook', 'hoop skirt', 'gymnastic horizontal bar',
    'horse-drawn vehicle', 'hourglass', 'iPod', 'clothes iron',
    'carved pumpkin', 'jeans', 'jeep', 'T-shirt', 'jigsaw puzzle', 'rickshaw',
    'joystick', 'kimono', 'knee pad', 'knot', 'lab coat', 'ladle', 'lampshade',
    'laptop computer', 'lawn mower', 'lens cap', 'letter opener', 'library',
    'lifeboat', 'lighter', 'limousine', 'ocean liner', 'lipstick',
    'slip-on shoe', 'lotion', 'music speaker', 'loupe magnifying glass',
    'sawmill', 'magnetic compass', 'messenger bag', 'mailbox', 'tights',
    'one-piece bathing suit', 'manhole cover', 'maraca', 'marimba', 'mask',
    'matchstick', 'maypole', 'maze', 'measuring cup', 'medicine cabinet',
    'megalith', 'microphone', 'microwave oven', 'military uniform', 'milk can',
    'minibus', 'miniskirt', 'minivan', 'missile', 'mitten', 'mixing bowl',
    'mobile home', 'ford model t', 'modem', 'monastery', 'monitor', 'moped',
    'mortar and pestle', 'graduation cap', 'mosque', 'mosquito net', 'vespa',
    'mountain bike', 'tent', 'computer mouse', 'mousetrap', 'moving van',
    'muzzle', 'metal nail', 'neck brace', 'necklace', 'baby pacifier',
    'notebook computer', 'obelisk', 'oboe', 'ocarina', 'odometer',
    'oil filter', 'pipe organ', 'oscilloscope', 'overskirt', 'bullock cart',
    'oxygen mask', 'product packet / packaging', 'paddle', 'paddle wheel',
    'padlock', 'paintbrush', 'pajamas', 'palace', 'pan flute', 'paper towel',
    'parachute', 'parallel bars', 'park bench', 'parking meter',
    'railroad car', 'patio', 'payphone', 'pedestal', 'pencil case',
    'pencil sharpener', 'perfume', 'Petri dish', 'photocopier', 'plectrum',
    'Pickelhaube', 'picket fence', 'pickup truck', 'pier', 'piggy bank',
    'pill bottle', 'pillow', 'ping-pong ball', 'pinwheel', 'pirate ship',
    'drink pitcher', 'block plane', 'planetarium', 'plastic bag', 'plate rack',
    'farm plow', 'plunger', 'Polaroid camera', 'pole', 'police van', 'poncho',
    'pool table', 'soda bottle', 'plant pot', "potter's wheel", 'power drill',
    'prayer rug', 'printer', 'prison', 'missile', 'projector', 'hockey puck',
    'punching bag', 'purse', 'quill', 'quilt', 'race car', 'racket',
    'radiator', 'radio', 'radio telescope', 'rain barrel',
    'recreational vehicle', 'fishing casting reel', 'reflex camera',
    'refrigerator', 'remote control', 'restaurant', 'revolver', 'rifle',
    'rocking chair', 'rotisserie', 'eraser', 'rugby ball',
    'ruler measuring stick', 'sneaker', 'safe', 'safety pin', 'salt shaker',
    'sandal', 'sarong', 'saxophone', 'scabbard', 'weighing scale',
    'school bus', 'schooner', 'scoreboard', 'CRT monitor', 'screw',
    'screwdriver', 'seat belt', 'sewing machine', 'shield', 'shoe store',
    'shoji screen / room divider', 'shopping basket', 'shopping cart',
    'shovel', 'shower cap', 'shower curtain', 'ski', 'balaclava ski mask',
    'sleeping bag', 'slide rule', 'sliding door', 'slot machine', 'snorkel',
    'snowmobile', 'snowplow', 'soap dispenser', 'soccer ball', 'sock',
    'solar thermal collector', 'sombrero', 'soup bowl', 'keyboard space bar',
    'space heater', 'space shuttle', 'spatula', 'motorboat', 'spider web',
    'spindle', 'sports car', 'spotlight', 'stage', 'steam locomotive',
    'through arch bridge', 'steel drum', 'stethoscope', 'scarf', 'stone wall',
    'stopwatch', 'stove', 'strainer', 'tram', 'stretcher', 'couch', 'stupa',
    'submarine', 'suit', 'sundial', 'sunglasses', 'sunglasses', 'sunscreen',
    'suspension bridge', 'mop', 'sweatshirt', 'swim trunks / shorts', 'swing',
    'electrical switch', 'syringe', 'table lamp', 'tank', 'tape player',
    'teapot', 'teddy bear', 'television', 'tennis ball', 'thatched roof',
    'front curtain', 'thimble', 'threshing machine', 'throne', 'tile roof',
    'toaster', 'tobacco shop', 'toilet seat', 'torch', 'totem pole',
    'tow truck', 'toy store', 'tractor', 'semi-trailer truck', 'tray',
    'trench coat', 'tricycle', 'trimaran', 'tripod', 'triumphal arch',
    'trolleybus', 'trombone', 'hot tub', 'turnstile', 'typewriter keyboard',
    'umbrella', 'unicycle', 'upright piano', 'vacuum cleaner', 'vase',
    'vaulted or arched ceiling', 'velvet fabric', 'vending machine',
    'vestment', 'viaduct', 'violin', 'volleyball', 'waffle iron', 'wall clock',
    'wallet', 'wardrobe', 'military aircraft', 'sink', 'washing machine',
    'water bottle', 'water jug', 'water tower', 'whiskey jug', 'whistle',
    'hair wig', 'window screen', 'window shade', 'Windsor tie', 'wine bottle',
    'airplane wing', 'wok', 'wooden spoon', 'wool', 'split-rail fence',
    'shipwreck', 'sailboat', 'yurt', 'website', 'comic book', 'crossword',
    'traffic or street sign', 'traffic light', 'dust jacket', 'menu', 'plate',
    'guacamole', 'consomme', 'hot pot', 'trifle', 'ice cream', 'popsicle',
    'baguette', 'bagel', 'pretzel', 'cheeseburger', 'hot dog',
    'mashed potatoes', 'cabbage', 'broccoli', 'cauliflower', 'zucchini',
    'spaghetti squash', 'acorn squash', 'butternut squash', 'cucumber',
    'artichoke', 'bell pepper', 'cardoon', 'mushroom', 'Granny Smith apple',
    'strawberry', 'orange', 'lemon', 'fig', 'pineapple', 'banana', 'jackfruit',
    'cherimoya (custard apple)', 'pomegranate', 'hay', 'carbonara',
    'chocolate syrup', 'dough', 'meatloaf', 'pizza', 'pot pie', 'burrito',
    'red wine', 'espresso', 'tea cup', 'eggnog', 'mountain', 'bubble', 'cliff',
    'coral reef', 'geyser', 'lakeshore', 'promontory', 'sandbar', 'beach',
    'valley', 'volcano', 'baseball player', 'bridegroom', 'scuba diver',
    'rapeseed', 'daisy', "yellow lady's slipper", 'corn', 'acorn', 'rose hip',
    'horse chestnut seed', 'coral fungus', 'agaric', 'gyromitra',
    'stinkhorn mushroom', 'earth star fungus', 'hen of the woods mushroom',
    'bolete', 'corn cob', 'toilet paper')
