from onnxsim import simplify
import onnx

model = onnx.load("bert_best_static.onnx")
model_simp, check = simplify(model,
                              input_shapes={"input": [64, 256]},  # 显式指定 shape（虽然静态模型已固定）
                              dynamic_input_shape=False)
assert check, "Simplified model could not be validated"
onnx.save(model_simp, "bert_best_static_sim.onnx")
print("✅ 优化成功！")  