from collections import Counter
import sys

def process_log(input_file, output_file):
    counts = Counter()

    with open(input_file, 'r') as f:
        for line in f:
#            if "./rocblas-bench -f gemm" in line:
            if "./bin/MIOpenDriver" in line:
                # 对每一行去除前后空格后进行计数
                counts[line.strip()] += 1

    with open(output_file, 'w') as f_out:
        for line, count in counts.items():
            # 仅保留出现次数超过1000次的行
            f_out.write(f"{count} {line}\n")

# 调用函数处理日志
in_file = sys.argv[1]
out_file = sys.argv[2]
process_log(in_file, out_file)

