// hip_resize_device_vector.cpp
#include <hip/hip_runtime.h>
#include <thrust/device_vector.h>
#include <cstdint>
#include <iostream>
#include <thrust/host_vector.h>  
int main() {
    const size_t size_in_bytes = 200 * 1024; // 200 KB

    try {
        // 创建一个空的 device_vector
        thrust::device_vector<uint8_t> d_vec;

        // 分配 200 KB 内存（即 200 * 1024 个 uint8_t 元素）
        d_vec.resize(size_in_bytes);
        std::cout << "Successfully allocated " << size_in_bytes << " bytes on GPU." << std::endl;
        std::cout << "Device vector size: " << d_vec.size() << " elements." << std::endl;

        // // 将 GPU 数据复制到 CPU
        // thrust::device_vector<uint8_t> d_vec(100,1);
        // thrust::host_vector<uint8_t> h_vec = d_vec;

        // // 打印前 10 个字节和最后 1 个字节
        // std::cout << "First 10 bytes: ";
        // for (size_t i = 0; i < 10 && i < h_vec.size(); ++i) {
        //     std::cout << static_cast<int>(h_vec[i]) << " ";
        // }
        // std::cout << "\nLast byte: " << static_cast<int>(h_vec.back()) << std::endl;


        uint8_t* raw_ptr = thrust::raw_pointer_cast(d_vec.data());
        if (raw_ptr != nullptr) {
            // std::cout << "GPU memory allocated successfully at: " << raw_ptr << std::endl;
            std::cout << "GPU memory allocated at address: 0x" 
              << std::hex << reinterpret_cast<uintptr_t>(raw_ptr) << std::dec << std::endl;
        } else {
            std::cerr << "Failed to allocate GPU memory!" << std::endl;
            return -1;
        }

        // 可选：验证分配是否成功（例如通过访问第一个和最后一个元素）
        if (!d_vec.empty()) {
            d_vec[0] = 42;
            d_vec.back() = 24;
            std::cout << "Test write successful." << std::endl;
        }

    } catch (const std::exception& e) {
        std::cerr << "Error: " << e.what() << std::endl;
        return -1;
    }

    return 0;
}