#!/bin/bash

CONTAINER_NAME="bytemlperf-TF"
image_name="image.sourcefind.cn:5000/dcu/admin/base/tensorflow:2.13.1-py3.10-dtk24.04.3-ubuntu20.04"

# 检查容器是否存在
if docker container ls -a --format '{{.Names}}' | grep -q "^$CONTAINER_NAME$"; then
    con_state=`docker inspect $CONTAINER_NAME | grep -i Status | awk '{printf "%s", $2}'`
    con_state=${con_state:1:-2}
    echo CONTAINER state:====== $con_state ======
    # if docker inspect -f '{{.State.Running}}' "$CONTAINER_NAME" > ./null 2>&1; then
    if [[ $con_state == "exited" ]]; then
        docker start $CONTAINER_NAME
    fi
    docker exec -it $CONTAINER_NAME /bin/bash
else
    docker run -id \
    --shm-size 200g \
    --network=host \
    --name=$CONTAINER_NAME \
    --privileged \
    --device=/dev/kfd \
    --device=/dev/dri \
    --device=/dev/mkfd \
    --ipc=host \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    -v /opt/hyhal/:/opt/hyhal/ \
    -v /datav/sunzhq/:/datav/sunzhq/ \
    -v /home/workspace/:/home/workspace/ \
    $image_name /bin/bash

    docker exec -it $CONTAINER_NAME /bin/bash
    pip config set global.index-url https://pypi.doubanio.com/simple
fi