## 文件结构
```
    ---models
        ---model_1
            --- dataset
            --- logs
            --- mxr
            --- trt
            --- onnx
        ---model_2
            --- dataset
            --- logs
        ---model_3
            --- dataset
            --- logs
```

## DCU 环境配置

```
    1. 拉去docker 镜像
    docker pull image.sourcefind.cn:5000/dcu/admin/base/tensorflow:2.13.1-py3.10-dtk24.04.3-ubuntu20.04

    2. 创建容器
    # CONTAINER_NAME 容器的名字
    docker run -id \
    --shm-size 200g \
    --network=host \
    --name=$CONTAINER_NAME \
    --privileged \
    --device=/dev/kfd \
    --device=/dev/dri \
    --device=/dev/mkfd \
    --ipc=host \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    -v /opt/hyhal/:/opt/hyhal/ \
    image.sourcefind.cn:5000/dcu/admin/base/tensorflow:2.13.1-py3.10-dtk24.04.3-ubuntu20.04 /bin/bash

    3. 启动进入镜像
    docker exec -it $CONTAINER_NAME /bin/bash
    
    4. 安装 migraphx
    下载 https://download.sourcefind.cn:65024/directlink/4/migraphx/DAS1.3/migraphx-4.5.0+das.opt1.dtk24043-cp310-cp310-manylinux_2_28_x86_64.run

    bash migraphx-4.5.0+das.opt1.dtk24043-cp310-cp310-manylinux_2_28_x86_64.run 可以正常安装
```

## L20 环境配置
```
    TF 测试镜像 docker pull nvcr.io/nvidia/tensorflow:23.10-tf2-py3
    trtexec 测试镜像 docker pull nvcr.io/nvidia/tensorrt:24.09-py3

```


## 测试数据生成
    - python ./utils/generate_data.py 
    相关参数指定见 generate_data.py 文件 

## model_1 模型转换

    
    - python ./utils/convert_pb_onnx.py

    - python ./utils/convert_onnx_dynamic_to_static.py

## TF 推理

    - python ./src/tf_session_infer.py
    测试数据输出到对应模型的logs文件目录下

## model_1 转 mxr 和 trt 模型

    - python ./src/onnx2mxr.py
    - bash ./src/onnx2trt.sh

## model_1 migraphx-driver 推理
    - bash ./src/migraphx-driver.sh

## model_1 trtexec 推理
    - bash ./src/trtexec.sh