#!/bin/bash

# # 定义输入模型路径和输出模型路径的基本部分
# input_model="./model_zoo/regular/open_resnet50/resnet50-torch-fp32.onnx"
# output_model_base="./model_zoo/regular/open_resnet50/resnet50-mir-fp32"

# # 定义不同的批量大小
# batch_sizes=(1 32 64 128 256 512 1024 2048)  # 根据需要可以调整

# # 循环遍历每个批量大小
# for bs in "${batch_sizes[@]}"; do
#     # 构造输出模型文件名
#     output_model="${output_model_base}-${bs}.onnx"
    
#     # 构造 input_shape_dict
#     input_shape_dict="{'input_1.1': [${bs}, 3, 224, 224]}"
    
#     # 执行转换命令
#     command="python -m paddle2onnx.optimize --input_model ${input_model} --output_model ${output_model} --input_shape_dict=\"${input_shape_dict}\""
    
#     # 打印命令以供调试
#     echo "Executing: ${command}"
    
#     # 执行命令
#     eval "${command}"
# done


# # 定义输入模型路径和输出模型路径的基本部分
# input_model="./model_zoo/regular/open_resnet50/resnet50-torch-fp16.onnx"
# output_model_base="./model_zoo/regular/open_resnet50/resnet50-mir-fp16"

# # 定义不同的批量大小
# batch_sizes=(1 32 64 128 256 512 1024 2048)  # 根据需要可以调整

# # 循环遍历每个批量大小
# for bs in "${batch_sizes[@]}"; do
#     # 构造输出模型文件名
#     output_model="${output_model_base}-${bs}.onnx"
    
#     # 构造 input_shape_dict
#     input_shape_dict="{'input_1.1': [${bs}, 3, 224, 224]}"
    
#     # 执行转换命令
#     command="python -m paddle2onnx.optimize --input_model ${input_model} --output_model ${output_model} --input_shape_dict=\"${input_shape_dict}\""
    
#     # 打印命令以供调试
#     echo "Executing: ${command}"
    
#     # 执行命令
#     eval "${command}"
# done


# 定义输入模型路径和输出模型路径的基本部分
input_model="/home/workspace/ByteMLPerf/byte_infer_perf/general_perf/test/bert-best-fp16.onnx"
output_model_base="/home/workspace/ByteMLPerf/byte_infer_perf/general_perf/test/bert-mir-fp16"

# 定义不同的批量大小
batch_sizes=(1 32 64 128)  # 根据需要可以调整

# 循环遍历每个批量大小
for bs in "${batch_sizes[@]}"; do
    # 构造输出模型文件名
    output_model="${output_model_base}-${bs}.onnx"
    
    # 构造 input_shape_dict
    input_shape_dict="{'input_ids.1': [${bs},384], 'attention_mask.1': [${bs},384], 'token_type_ids.1': [${bs},384]}"
    
    # 执行转换命令
    command="python -m paddle2onnx.optimize --input_model ${input_model} --output_model ${output_model} --input_shape_dict=\"${input_shape_dict}\""
    
    # 打印命令以供调试
    echo "Executing: ${command}"
    
    # 执行命令
    eval "${command}"
done


# 定义输入模型路径和输出模型路径的基本部分
# input_model="./model_zoo/regular/open_wide_deep_saved_model/widedeep-onnx-fp32.onnx"
# output_model_base="./model_zoo/regular/open_wide_deep_saved_model/widedeep-mir-fp32"

# # 定义不同的批量大小
# # batch_sizes=(1 1024 20000 40000 80000 120000)  # 根据需要可以调整
# batch_sizes=(140000 160000 180000 200000 220000 240000 260000)

# # 循环遍历每个批量大小
# for bs in "${batch_sizes[@]}"; do

#     new_value=$((bs * 26))
#     # 构造输出模型文件名
#     output_model="${output_model_base}-${bs}.onnx"
    
#     # 构造 input_shape_dict
#     input_shape_dict="{'new_categorical_placeholder:0': [${new_value}, 2], 'new_numeric_placeholder:0': [${bs}, 13]}"
    
#     # 执行转换命令
#     command="python -m paddle2onnx.optimize --input_model ${input_model} --output_model ${output_model} --input_shape_dict=\"${input_shape_dict}\""
    
#     # 打印命令以供调试
#     echo "Executing: ${command}"
    
#     # 执行命令
#     eval "${command}"
# done


# 定义输入模型路径和输出模型路径的基本部分
# input_model="./model_zoo/regular/open_wide_deep_saved_model/widedeep-onnx-fp16.onnx"
# output_model_base="./model_zoo/regular/open_wide_deep_saved_model/widedeep-mir-fp16"

# # 定义不同的批量大小
# # batch_sizes=(1 1024 20000 40000 80000 120000)  # 根据需要可以调整
# batch_sizes=(1 1024 20000 40000 80000 120000 140000 160000 180000 200000 220000 240000 260000)
# # 循环遍历每个批量大小
# for bs in "${batch_sizes[@]}"; do

#     new_value=$((bs * 26))
#     # 构造输出模型文件名
#     output_model="${output_model_base}-${bs}.onnx"
    
#     # 构造 input_shape_dict
#     input_shape_dict="{'new_categorical_placeholder:0': [${new_value}, 2], 'new_numeric_placeholder:0': [${bs}, 13]}"
    
#     # 执行转换命令
#     command="python -m paddle2onnx.optimize --input_model ${input_model} --output_model ${output_model} --input_shape_dict=\"${input_shape_dict}\""
    
#     # 打印命令以供调试
#     echo "Executing: ${command}"
    
#     # 执行命令
#     eval "${command}"
# done
