# Copyright (c) 2020, NVIDIA CORPORATION.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

__all__ = ["LATIN_TO_RU", "RU_ABBREVIATIONS"]

LATIN_TO_RU = {
    "a": "а",
    "b": "б",
    "c": "к",
    "d": "д",
    "e": "е",
    "f": "ф",
    "g": "г",
    "h": "х",
    "i": "и",
    "j": "ж",
    "k": "к",
    "l": "л",
    "m": "м",
    "n": "н",
    "o": "о",
    "p": "п",
    "q": "к",
    "r": "р",
    "s": "с",
    "t": "т",
    "u": "у",
    "v": "в",
    "w": "в",
    "x": "к",
    "y": "у",
    "z": "з",
    "à": "а",
    "è": "е",
    "é": "е",
    "ß": "в",
    "ä": "а",
    "ö": "о",
    "ü": "у",
    "є": "е",
    "ç": "с",
    "ê": "е",
    "ó": "о",
}

RU_ABBREVIATIONS = {
    " р.": " рублей",
    " к.": " копеек",
    " коп.": " копеек",
    " копек.": " копеек",
    " т.д.": " так далее",
    " т. д.": " так далее",
    " т.п.": " тому подобное",
    " т. п.": " тому подобное",
    " т.е.": " то есть",
    " т. е.": " то есть",
    " стр. ": " страница ",
}
