package main

import (
	"fmt"
	"k8s-device-plugin/internal/pkg/hwloc"
	"os"
)

var gitDescribe string

type ResourceNamingStrategy string

const (
	StrategySingle ResourceNamingStrategy = "single"
	StrategyMixed  ResourceNamingStrategy = "mixed"
)

func ParseStrategy(s string) (ResourceNamingStrategy, error) {
	switch s {
	case string(StrategySingle):
		return StrategySingle, nil
	case string(StrategyMixed):
		return StrategyMixed, nil
	default:
		return "", fmt.Errorf("invalid strategy: %s", s)
	}
}

func main() {
	versions := [...]string{
		"DCU device plugin for Kubernetes",
		fmt.Sprintf("%s version %s", os.Args[0], gitDescribe),
		fmt.Sprintf("%s", hwloc.GetVersions()),
	}
	for _, v := range versions {
		fmt.Println(v)
	}
}
