/**
# Copyright (c) 2024, HCUOpt CORPORATION.  All rights reserved.
**/

package dhcu

import (
	"dcu-container-toolkit/internal/c3000caps"
	"dcu-container-toolkit/internal/logger"
)

type options struct {
	logger         logger.Interface
	devRoot        string
	dtkCDIHookPath string

	isMigDevice bool
	// migCaps stores the MIG capabilities for the system.
	// If MIG is not available, this is nil.
	migCaps      c3000caps.MigCaps
	migCapsError error
}

type Option func(*options)

// WithDevRoot sets the root where /dev is located.
func WithDevRoot(root string) Option {
	return func(l *options) {
		l.devRoot = root
	}
}

// WithLogger sets the logger for the library
func WithLogger(logger logger.Interface) Option {
	return func(l *options) {
		l.logger = logger
	}
}

// WithDTKCDIHookPath sets the path to the DTK Container Toolkit CLI path for the library
func WithDTKCDIHookPath(path string) Option {
	return func(l *options) {
		l.dtkCDIHookPath = path
	}
}

// WithMIGCaps sets the MIG capabilities.
func WithMIGCaps(migCaps c3000caps.MigCaps) Option {
	return func(l *options) {
		l.migCaps = migCaps
	}
}
