/**
# Copyright (c) 2024, HCUOpt CORPORATION.  All rights reserved.
**/

package hook

import (
	"dcu-container-toolkit/cmd/dcu-cdi-hook/commands"
	"dcu-container-toolkit/internal/logger"

	"github.com/urfave/cli/v2"
)

type hookCommand struct {
	logger logger.Interface
}

// NewCommand constructs a hook command with the specified logger
func NewCommand(logger logger.Interface) *cli.Command {
	c := hookCommand{
		logger: logger,
	}
	return c.build()
}

// build
func (m hookCommand) build() *cli.Command {
	// Create the 'hook' command
	hook := cli.Command{
		Name:  "hook",
		Usage: "A collection of hooks that may be injected into an OCI spec",
	}

	hook.Subcommands = commands.New(m.logger)

	return &hook
}
