package initialize

import (
	dcuTracker "dcu-container-toolkit/internal/dcu-tracker"
	"fmt"
	"os/user"

	"dcu-container-toolkit/internal/logger"

	"github.com/urfave/cli/v2"
)

type command struct {
	logger logger.Interface
}

func NewCommand(logger logger.Interface) *cli.Command {
	c := command{
		logger: logger,
	}
	return c.build()
}

func (m command) build() *cli.Command {
	// dcuTrackerInitCmd initializes the DCU Tracker.
	dcuTrackerInitCmd := cli.Command{
		Name:      "init",
		Hidden:    true,
		Usage:     "Initialize the DCU Tracker",
		UsageText: "dcu-ctk dcu-tracker init [options]",
		Before:    func(c *cli.Context) error { return validateGenOptions(c) },
		Action:    func(c *cli.Context) error { return performAction(c) },
	}

	return &dcuTrackerInitCmd
}

func validateGenOptions(c *cli.Context) error {
	curUser, err := user.Current()
	if err != nil || curUser.Uid != "0" {
		return fmt.Errorf("Permission denied: Not running as root")
	}

	return nil
}

func performAction(c *cli.Context) error {
	dcuTracker, err := dcuTracker.New()
	if err != nil {
		return fmt.Errorf("Failed to create GPU tracker, Error: %v", err)
	}

	err = dcuTracker.Init()
	if err != nil {
		return fmt.Errorf("Failed to Initialize GPU Tracker, Error: %v", err)
	}

	return nil
}

