/**
# Copyright (c) 2024, HCUOpt CORPORATION.  All rights reserved.
**/

package engine

// Interface defines the API for a runtime config updater.
type Interface interface {
	DefaultRuntime() string
	AddRuntime(string, string, bool, ...map[string]interface{}) error
	Set(string, interface{})
	RemoveRuntime(string) error
	Save(string) (int64, error)
}
