package status

import (
	dcuTracker "dcu-container-toolkit/internal/dcu-tracker"
	"fmt"
	"os/user"

	"dcu-container-toolkit/internal/logger"

	"github.com/urfave/cli/v2"
)

type command struct {
	logger logger.Interface
}

func NewCommand(logger logger.Interface) *cli.Command {
	c := command{
		logger: logger,
	}
	return c.build()
}
func (c *command) build() *cli.Command {
	dcuTrackerStatusCmd := cli.Command{
		Name:      "status",
		Usage:     "Show Status of DCUs",
		UsageText: "dcu-ctk dcu-tracker status [options]",
		Before: func(c *cli.Context) error {
			return validateGenOptions(c)
		},
		Action: func(c *cli.Context) error {
			return performAction(c)
		},
	}

	return &dcuTrackerStatusCmd
}

func validateGenOptions(c *cli.Context) error {
	curUser, err := user.Current()
	if err != nil || curUser.Uid != "0" {
		return fmt.Errorf("Permission denied: Not running as root")
	}

	return nil
}

func performAction(c *cli.Context) error {
	dcuTracker, err := dcuTracker.New()
	if err != nil {
		return fmt.Errorf("Failed to create GPU tracker, Error: %v", err)
	}

	err = dcuTracker.ShowStatus()
	if err != nil {
		return fmt.Errorf("Failed to show GPUs status, Error: %v", err)
	}

	return nil
}

