/**
# Copyright (c) 2024, HCUOpt CORPORATION.  All rights reserved.
**/

package root

import "dcu-container-toolkit/internal/logger"

type Option func(*Driver)

func WithLogger(logger logger.Interface) Option {
	return func(d *Driver) {
		d.logger = logger
	}
}

func WithDriverRoot(root string) Option {
	return func(d *Driver) {
		d.Root = root
	}
}

func WithLibrarySearchPaths(paths ...string) Option {
	return func(d *Driver) {
		d.librarySearchPaths = paths
	}
}

func WithConfigSearchPaths(paths ...string) Option {
	return func(d *Driver) {
		d.configSearchPaths = paths
	}
}
