package docker

import (
	"dcu-container-toolkit/internal/logger"
	"dcu-container-toolkit/internal/query"
	"github.com/urfave/cli/v2"
)

type command struct {
	logger logger.Interface
}

type config struct {
	dcus string
}

func NewCommand(logger logger.Interface) *cli.Command {
	c := command{
		logger: logger,
	}
	return c.build()
}

func (m command) build() *cli.Command {
	cfg := config{}
	docker := cli.Command{
		Name:  "docker",
		Usage: "List which dockers are using the DCUs",
		Action: func(context *cli.Context) error {
			return m.run(context, &cfg)
		},
	}

	flags := []cli.Flag{
		&cli.StringFlag{
			Name:        "dcus",
			Aliases:     []string{"d"},
			Value:       "all",
			Usage:       "Show all DCUs, including those not in use",
			Destination: &cfg.dcus,
		},
	}
	docker.Flags = flags
	return &docker
}

func (m command) run(c *cli.Context, cfg *config) error {
	err := query.ShowStatus(cfg.dcus)
	if err != nil {
		return err
	}
	return nil
}

