#
# Copyright (c) 2024, HCUOpt CORPORATION.  All rights reserved.
#

function assert_usage() {
    exit 1
}

set -e

SCRIPTS_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )"/../scripts && pwd )"
PROJECT_ROOT="$( cd ${SCRIPTS_DIR}/.. && pwd )"

DTK_CONTAINER_TOOLKIT_ROOT=${PROJECT_ROOT}

versions_makefile=${DTK_CONTAINER_TOOLKIT_ROOT}/versions.mk

dtk_container_toolkit_version=$(grep -m 1 "^LIB_VERSION := " ${versions_makefile} | sed -e 's/LIB_VERSION :=[[:space:]]\(.*\)[[:space:]]*/\1/')
dtk_container_toolkit_tag=$(grep -m 1 "^LIB_TAG .= " ${versions_makefile} | sed -e 's/LIB_TAG .=[[:space:]]\(.*\)[[:space:]]*/\1/')
dtk_container_toolkit_version_tag="${dtk_container_toolkit_version}${dtk_container_toolkit_tag}:+~${dtk_container_toolkit_tag}"

echo "DTK_CONTAINER_TOOLKIT_VERSION=${dtk_container_toolkit_version}"
echo "DTK_CONTAINER_TOOLKIT_TAG=${dtk_container_toolkit_tag}"
echo "DTK_CONTAINER_TOOLKIT_PACKAGE_VERSION=${dtk_container_toolkit_version_tag//\~/-}"
