/**
# Copyright (c) 2024, HCUOpt CORPORATION.  All rights reserved.
**/

package modifier

import (
	"dcu-container-toolkit/internal/config"
	"dcu-container-toolkit/internal/config/image"
	"dcu-container-toolkit/internal/logger"
	"dcu-container-toolkit/internal/oci"
)

// NewStableModifier creates the modifiers for general features.
// These includes:
//
// removes inserted nvidia-container-runtime hooks for --gpus
func NewStableModifier(logger logger.Interface, cfg *config.Config, image image.DTK) (oci.SpecModifier, error) {
	var modifiers List

	modifiers = append(modifiers, NewNvidiaContainerRuntimeHookRemover(logger))
	modifiers = append(modifiers, NewSeccompRemover(logger))

	var addCaps []string

	// For xprof
	addCaps = append(addCaps, "CAP_SYS_RAWIO")
	if image.Getenv("DTK_MOFED") == "enabled" {
		addCaps = append(addCaps, "CAP_IPC_LOCK")
	}
	modifiers = append(modifiers, NewCapModifier(logger, addCaps, []string{}))

	return modifiers, nil
}
