package disable

import (
	dcuTracker "dtk-container-toolkit/internal/dcu-tracker"
	"fmt"
	"os/user"

	"dtk-container-toolkit/internal/logger"

	"github.com/urfave/cli/v2"
)

type command struct {
	logger logger.Interface
}

func NewCommand(logger logger.Interface) *cli.Command {
	c := command{
		logger: logger,
	}
	return c.build()
}

func (m command) build() *cli.Command {

	dcuTrackerDisableCmd := cli.Command{
		Name:      "disable",
		Usage:     "Disable the DCU Tracker",
		UsageText: "dtk-ctk dcu-tracker disable [options]",
		Before:    func(c *cli.Context) error { return validateGenOptions(c) },
		Action:    func(c *cli.Context) error { return performAction(c) },
	}

	return &dcuTrackerDisableCmd
}

func validateGenOptions(c *cli.Context) error {
	curUser, err := user.Current()
	if err != nil || curUser.Uid != "0" {
		return fmt.Errorf("Permission denied: Not running as root")
	}

	return nil
}

func performAction(c *cli.Context) error {
	dcuTracker, err := dcuTracker.New()
	if err != nil {
		return fmt.Errorf("Failed to create GPU tracker, Error: %v", err)
	}

	err = dcuTracker.Disable()
	if err != nil {
		return fmt.Errorf("Failed to Reset GPU Tracker, Error: %v", err)
	}

	return nil
}

