/**
# Copyright (c) 2024, HCUOpt CORPORATION.  All rights reserved.
**/

package root

// Option defines a functional option for configuring a transormer.
type Option func(*builder)

// WithRoot sets the (from) root for the root transformer.
func WithRoot(root string) Option {
	return func(b *builder) {
		b.root = root
	}
}

// WithTargetRoot sets the (to) target root for the root transformer.
func WithTargetRoot(root string) Option {
	return func(b *builder) {
		b.targetRoot = root
	}
}

// WithRelativeTo sets whether the specified root is relative to the host or container.
func WithRelativeTo(relativeTo string) Option {
	return func(b *builder) {
		b.relativeTo = relativeTo
	}
}
