Name: dcu-container-toolkit
Version: %{version}
Release: %{release}
Group: Development Tools

Vendor: HCUOpt CORPORATION
Packager: HCUOpt CORPORATION

Summary: DTK Container Toolkit
License: Apache-2.0

Source0: dcu-ctk
Source1: dcu-container-runtime
Source2: dcu-cdi-hook
Source3: LICENSE
Source4: dcu-docker

%description
Provides tools and utilities to enable HCU support in containers.

%prep
cp %{SOURCE0} %{SOURCE1} %{SOURCE2} %{SOURCE3} %{SOURCE4} .

%install
mkdir -p %{buildroot}%{_bindir}
install -m 755 -t %{buildroot}%{_bindir} dcu-container-runtime
install -m 755 -t %{buildroot}%{_bindir} dcu-ctk
install -m 755 -t %{buildroot}%{_bindir} dcu-cdi-hook
install -m 755 -t %{buildroot}%{_bindir} dcu-docker

%posttrans
if [ ! -e %{_bindir}/nvidia-container-runtime-hook ]; then
  # repairing lost file nvidia-container-runtime-hook
  ln -sf %{_bindir}/dcu-container-runtime %{_bindir}/nvidia-container-runtime-hook
fi

# Generate the default config; If this file already exists no changes are made.
%{_bindir}/dcu-ctk --quiet config --config-file=%{_sysconfdir}/dcu-container-runtime/config.toml --in-place

%{_bindir}/dcu-ctk runtime configure --runtime=docker --set-as-default
echo -e "\e[032m ================================== \e[0m"
echo -e "\e[033m Please restart Docker service:     \e[0m"
echo -e "\e[033m    sudo systemctl restart docker   \e[0m"
echo -e "\e[032m ================================== \e[0m"

%postun
if [ "$1" = 0 ]; then  # package is uninstalled, not upgraded
  if [ -L %{_bindir}/nvidia-container-runtime-hook ]; then rm -f %{_bindir}/nvidia-container-runtime-hook; fi
  if [ -e %{_bindir}/sdocker ]; then mv %{_bindir}/sdocker %{_bindir}/docker; fi
fi

%files
%license LICENSE
%{_bindir}/dcu-ctk
%{_bindir}/dcu-container-runtime
%{_bindir}/dcu-cdi-hook
%{_bindir}/dcu-docker
%changelog
* %{release_date} HCUOpt CORPORATION %{version}-%{release}
- initialize version
