Name: dtk-container-toolkit
Version: %{version}
Release: %{release}
Group: Development Tools

Vendor: HCUOpt CORPORATION
Packager: HCUOpt CORPORATION

Summary: DTK Container Toolkit
License: Apache-2.0

Source0: dtk-ctk
Source1: dtk-container-runtime
Source2: dtk-cdi-hook
Source3: LICENSE

%description
Provides tools and utilities to enable HCU support in containers.

%prep
cp %{SOURCE0} %{SOURCE1} %{SOURCE2} %{SOURCE3} .

%install
mkdir -p %{buildroot}%{_bindir}
install -m 755 -t %{buildroot}%{_bindir} dtk-container-runtime
install -m 755 -t %{buildroot}%{_bindir} dtk-ctk
install -m 755 -t %{buildroot}%{_bindir} dtk-cdi-hook

%posttrans
if [ ! -e %{_bindir}/nvidia-container-runtime-hook ]; then
  # repairing lost file nvidia-container-runtime-hook
  ln -sf %{_bindir}/dtk-container-runtime %{_bindir}/nvidia-container-runtime-hook
fi

# Generate the default config; If this file already exists no changes are made.
%{_bindir}/dtk-ctk --quiet config --config-file=%{_sysconfdir}/dtk-container-runtime/config.toml --in-place

%{_bindir}/dtk-ctk runtime configure --runtime=docker --set-as-default
echo -e "\e[032m ================================== \e[0m"
echo -e "\e[033m Please restart Docker service:     \e[0m"
echo -e "\e[033m    sudo systemctl restart docker   \e[0m"
echo -e "\e[032m ================================== \e[0m"

%postun
if [ "$1" = 0 ]; then  # package is uninstalled, not upgraded
  if [ -L %{_bindir}/nvidia-container-runtime-hook ]; then rm -f %{_bindir}/nvidia-container-runtime-hook; fi
fi

%files
%license LICENSE
%{_bindir}/dtk-ctk
%{_bindir}/dtk-container-runtime
%{_bindir}/dtk-cdi-hook
%changelog
* %{release_date} HCUOpt CORPORATION %{version}-%{release}
- initialize version