// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package oci

import (
	"github.com/opencontainers/runtime-spec/specs-go"
	"sync"
)

// Ensure, that SpecMock does implement Spec.
// If this is not the case, regenerate this file with moq.
var _ Spec = &SpecMock{}

// SpecMock is a mock implementation of Spec.
//
//	func TestSomethingThatUsesSpec(t *testing.T) {
//
//		// make and configure a mocked Spec
//		mockedSpec := &SpecMock{
//			FlushFunc: func() error {
//				panic("mock out the Flush method")
//			},
//			LoadFunc: func() (*specs.Spec, error) {
//				panic("mock out the Load method")
//			},
//			LookupEnvFunc: func(s string) (string, bool) {
//				panic("mock out the LookupEnv method")
//			},
//			ModifyFunc: func(specModifier SpecModifier) error {
//				panic("mock out the Modify method")
//			},
//		}
//
//		// use mockedSpec in code that requires Spec
//		// and then make assertions.
//
//	}
type SpecMock struct {
	// FlushFunc mocks the Flush method.
	FlushFunc func() error

	// LoadFunc mocks the Load method.
	LoadFunc func() (*specs.Spec, error)

	// LookupEnvFunc mocks the LookupEnv method.
	LookupEnvFunc func(s string) (string, bool)

	// ModifyFunc mocks the Modify method.
	ModifyFunc func(specModifier SpecModifier) error

	// calls tracks calls to the methods.
	calls struct {
		// Flush holds details about calls to the Flush method.
		Flush []struct {
		}
		// Load holds details about calls to the Load method.
		Load []struct {
		}
		// LookupEnv holds details about calls to the LookupEnv method.
		LookupEnv []struct {
			// S is the s argument value.
			S string
		}
		// Modify holds details about calls to the Modify method.
		Modify []struct {
			// SpecModifier is the specModifier argument value.
			SpecModifier SpecModifier
		}
	}
	lockFlush     sync.RWMutex
	lockLoad      sync.RWMutex
	lockLookupEnv sync.RWMutex
	lockModify    sync.RWMutex
}

// Flush calls FlushFunc.
func (mock *SpecMock) Flush() error {
	callInfo := struct {
	}{}
	mock.lockFlush.Lock()
	mock.calls.Flush = append(mock.calls.Flush, callInfo)
	mock.lockFlush.Unlock()
	if mock.FlushFunc == nil {
		var (
			errOut error
		)
		return errOut
	}
	return mock.FlushFunc()
}

// FlushCalls gets all the calls that were made to Flush.
// Check the length with:
//
//	len(mockedSpec.FlushCalls())
func (mock *SpecMock) FlushCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockFlush.RLock()
	calls = mock.calls.Flush
	mock.lockFlush.RUnlock()
	return calls
}

// Load calls LoadFunc.
func (mock *SpecMock) Load() (*specs.Spec, error) {
	callInfo := struct {
	}{}
	mock.lockLoad.Lock()
	mock.calls.Load = append(mock.calls.Load, callInfo)
	mock.lockLoad.Unlock()
	if mock.LoadFunc == nil {
		var (
			specOut *specs.Spec
			errOut  error
		)
		return specOut, errOut
	}
	return mock.LoadFunc()
}

// LoadCalls gets all the calls that were made to Load.
// Check the length with:
//
//	len(mockedSpec.LoadCalls())
func (mock *SpecMock) LoadCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockLoad.RLock()
	calls = mock.calls.Load
	mock.lockLoad.RUnlock()
	return calls
}

// LookupEnv calls LookupEnvFunc.
func (mock *SpecMock) LookupEnv(s string) (string, bool) {
	callInfo := struct {
		S string
	}{
		S: s,
	}
	mock.lockLookupEnv.Lock()
	mock.calls.LookupEnv = append(mock.calls.LookupEnv, callInfo)
	mock.lockLookupEnv.Unlock()
	if mock.LookupEnvFunc == nil {
		var (
			sOut string
			bOut bool
		)
		return sOut, bOut
	}
	return mock.LookupEnvFunc(s)
}

// LookupEnvCalls gets all the calls that were made to LookupEnv.
// Check the length with:
//
//	len(mockedSpec.LookupEnvCalls())
func (mock *SpecMock) LookupEnvCalls() []struct {
	S string
} {
	var calls []struct {
		S string
	}
	mock.lockLookupEnv.RLock()
	calls = mock.calls.LookupEnv
	mock.lockLookupEnv.RUnlock()
	return calls
}

// Modify calls ModifyFunc.
func (mock *SpecMock) Modify(specModifier SpecModifier) error {
	callInfo := struct {
		SpecModifier SpecModifier
	}{
		SpecModifier: specModifier,
	}
	mock.lockModify.Lock()
	mock.calls.Modify = append(mock.calls.Modify, callInfo)
	mock.lockModify.Unlock()
	if mock.ModifyFunc == nil {
		var (
			errOut error
		)
		return errOut
	}
	return mock.ModifyFunc(specModifier)
}

// ModifyCalls gets all the calls that were made to Modify.
// Check the length with:
//
//	len(mockedSpec.ModifyCalls())
func (mock *SpecMock) ModifyCalls() []struct {
	SpecModifier SpecModifier
} {
	var calls []struct {
		SpecModifier SpecModifier
	}
	mock.lockModify.RLock()
	calls = mock.calls.Modify
	mock.lockModify.RUnlock()
	return calls
}
