# DTK Container Toolkit

## 简介

DTK Container Toolkit 使用户能够构建和运行使用HCU设备的容器。该工具包包含一个容器运行时和一些用于自动配置容器以利用HCU的实用程序。

## 使用

首先确保已经安装好DTK。

### 安装

在 HCUOpt 发布仓库里找到适合系统的安装包，使用 dpkg/rpm -i 进行安装。

重启docker服务
```sh
$ sudo systemctl restart docker
```

### 在容器中使用HCU

#### 通过 docker CLI
可以通过 docker run 添加参数 --gpus 给容器添加HCU设备。
```sh
$ docker run -it --gpus all ubuntu:18.04    # 添加所有HCU设备
$ docker run -it --gpus 1 ubuntu:18.04 # 添加一个HCU设备，HCU 0
```

#### 通过环境变量 `DTK_VISIBLE_DEVICES`
可以通过 docker run 添加环境变量 -e DTK_VISIBLE_DEVICES 给容器添加HCU设备。
```sh
docker run -it -e DTK_VISIBLE_DEVICES=all ubuntu:18.04 # 添加所有HCU设备
docker run -it -e DTK_VISIBLE_DEVICES=0 ubuntu:18.04 # 添加HCU设备0
docker run -it -e DTK_VISIBLE_DEVICES=0,1 ubuntu:18.04 # 添加HCU设备0、1
```
