/**
# Copyright (c) 2024, HCUOpt CORPORATION.  All rights reserved.
**/

package root

import (
	"dcu-container-toolkit/pkg/c3000cdi/transform"
	"dcu-container-toolkit/pkg/c3000cdi/transform/noop"
)

type builder struct {
	transformer
	relativeTo string
}

func (b *builder) build() transform.Transformer {
	if b.root == b.targetRoot {
		return noop.New()
	}

	if b.relativeTo == "container" {
		return containerRootTransformer(b.transformer)
	}
	return hostRootTransformer(b.transformer)
}
