/**
# Copyright (c) 2024, HCUOpt CORPORATION.  All rights reserved.
**/

package discover

import "dcu-container-toolkit/internal/logger"

// NewMOFEDDiscoverer creates a discoverer for MOFED devices.
func NewMOFEDDiscoverer(logger logger.Interface, devRoot string) (Discover, error) {
	devices := NewCharDeviceDiscoverer(
		logger,
		devRoot,
		[]string{
			"/dev/infiniband/uverbs*",
			"/dev/infiniband/rdma_cm",
		},
	)

	return devices, nil
}
