/**
# Copyright (c) 2024, HCUOpt CORPORATION.  All rights reserved.
**/

package commands

import (
	"dcu-container-toolkit/cmd/dcu-cdi-hook/chmod"
	symlinks "dcu-container-toolkit/cmd/dcu-cdi-hook/create-symlinks"
	"dcu-container-toolkit/internal/logger"

	"github.com/urfave/cli/v2"
)

// New creates the commands associated with supported CDI hooks.
// These are shared by the dcu-cdi-hook and dcu-ctk hook commands.
func New(logger logger.Interface) []*cli.Command {
	return []*cli.Command{
		symlinks.NewCommand(logger),
		chmod.NewCommand(logger),
	}
}
