/**
# Copyright (c) 2024, HCUOpt CORPORATION.  All rights reserved.
**/

package dhcu

import (
	"dtk-container-toolkit/internal/discover"
	"dtk-container-toolkit/internal/info/drm"
	"dtk-container-toolkit/internal/lookup"
	"dtk-container-toolkit/pkg/go-c3000lib/pkg/device"
	"fmt"
)

func (o *options) newC3000SimDHCUDiscoverer(d device.Device) (discover.Discover, error) {
	pciBusID := d.GetPCIBusID()
	drmDeviceNodes, err := drm.GetDeviceNodesByBusID(pciBusID)
	if err != nil {
		return nil, fmt.Errorf("failed to determine DRM devices for %v: %v", pciBusID, err)
	}

	deviceNodes := discover.NewCharDeviceDiscoverer(
		o.logger,
		o.devRoot,
		drmDeviceNodes,
	)

	byPathHooks := discover.NewCreateDRMByPathSymlinks(o.logger, deviceNodes, o.devRoot, o.dtkCDIHookPath)

	pciMounts := discover.NewPciMounts(
		o.logger,
		lookup.NewDirectoryLocator(
			lookup.WithLogger(o.logger),
			lookup.WithCount(1),
			lookup.WithSearchPaths("/sys/bus/pci/devices"),
		),
		o.devRoot,
		[]string{pciBusID},
	)

	dd := discover.Merge(
		deviceNodes,
		byPathHooks,
		pciMounts,
	)
	return dd, nil
}
