/**
# Copyright (c) 2024, HCUOpt CORPORATION.  All rights reserved.
**/

package commands

import (
	"dtk-container-toolkit/cmd/dtk-cdi-hook/chmod"
	symlinks "dtk-container-toolkit/cmd/dtk-cdi-hook/create-symlinks"
	"dtk-container-toolkit/internal/logger"

	"github.com/urfave/cli/v2"
)

// New creates the commands associated with supported CDI hooks.
// These are shared by the dtk-cdi-hook and dtk-ctk hook commands.
func New(logger logger.Interface) []*cli.Command {
	return []*cli.Command{
		symlinks.NewCommand(logger),
		chmod.NewCommand(logger),
	}
}
