# Mobilenetv2

## 论文

MobileNetV2: Inverted Residuals and Linear Bottlenecks

- https://openaccess.thecvf.com/content_cvpr_2018/papers/Sandler_MobileNetV2_Inverted_Residuals_CVPR_2018_paper.pdf

## 模型结构

MobileNetV2是一种轻量级的卷积神经网络模型，由Google在2018年提出。它是MobileNet系列中的第二个版本，主要用于移动设备和嵌入式设备等资源受限的环境中进行图像分类、目标检测等计算机视觉任务。

![d15a0e56517b4f7284a862f1d6eaef9a](./images/d15a0e56517b4f7284a862f1d6eaef9a.png)



## 算法原理

MobileNetV2的网络结构主要由两部分组成：特征提取层和分类器。

![20231124104337](./images/20231124104337.png)

## 环境配置

### Docker（方法一）

```python
git clone --recursive http://developer.hpccube.com/codes/modelzoo/mobilenetv2_mmcv.git
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
# <your IMAGE ID>用以上拉取的docker的镜像ID替换
docker run --shm-size 10g --network=host --name=mobilenetv2 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/mobilenetv2_mmcv:/home/mobilenetv2_mmcv -it <your IMAGE ID> bash

cd mobilenetv2_mmcv/mmclassification-mmcv
pip install -r requirements.txt
```

### Dockerfile（方法二）

```plaintext
cd mobilenetv2_mmcv/docker
docker build --no-cache -t mobilenetv2_mmcv:latest .
docker run --rm --shm-size 10g --network=host --name=mobilenetv2 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/../../mobilenetv2_mmcv:/home/mobilenetv2_mmcv -it <your IMAGE ID> bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt
```

### Anaconda（方法三）

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/

```plaintext
DTK驱动：dtk22.10.1
python：python3.7
torch:1.10.0
torchvision:0.10.0
mmcv：1.6.1
Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应
```

2、其它非特殊库参照requirements.txt安装

```plaintext
pip install -r requirements.txt
```

## 数据集

在本测试中可以使用ImageNet数据集。

下载ImageNet数据集：https://image-net.org/

下载val数据：链接：https://pan.baidu.com/s/1oXsmsYahGVG3uOZ8e535LA?pwd=c3bc 提取码：c3bc 替换ImageNet数据集中的val目录，处理后的数据结构如下：

```
data
    ├──imagenet
        ├── meta
            ├──val.txt
            ├──train.txt
            ...
        ├── train
        ├── val
  
```
SCNet快速下载链接[http://113.200.138.88:18080/aidatasets/project-dependency/imagenet-2012
](http://113.200.138.88:18080/aidatasets/project-dependency/imagenet-2012
)
## 训练

将训练数据解压到data目录下。

### 单机8卡

    ./mobilenetv2.sh

## result

![img](https://developer.hpccube.com/codes/modelzoo/vit_pytorch/-/raw/master/image/README/1695381570003.png)

### 精度

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数 |           精度            |
| :--: | :-----------------------: |
|  8   | top1:0.71764;top5:0.90386 |

## 应用场景

### 算法类别

图像分类

### 热点行业

制造,能源,交通,网安

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/mobilenetv2_mmcv

## 参考资料

https://github.com/open-mmlab/mmpretrain
