# Mobilenetv2

## 模型介绍

MobileNetV2是一种轻量级的卷积神经网络模型，由Google在2018年提出。它是MobileNet系列中的第二个版本，主要用于移动设备和嵌入式设备等资源受限的环境中进行图像分类、目标检测等计算机视觉任务。

## 模型结构

MobileNetV2的网络结构主要由两部分组成：特征提取层和分类器。

特征提取层采用了一连串的瓶颈块来减小模型大小和计算量。每个瓶颈块包括逐点卷积、逐通道扩展和逐点卷积三个操作。其中逐点卷积用于降低特征图的通道数量，逐通道扩展则是为了增加特征图的深度，逐点卷积再次将通道数量转换为更小的值。MobileNetV2引入了倒残差结构，即先使用逐点卷积缩小通道数量，然后使用瓶颈块处理特征图，最后再使用逐点卷积扩展通道数量。最后一个重要的设计是Squeeze-and-Excitation (SE)模块，它可以用于进一步优化特征提取。SE模块通过使用全局平均池化来获取特征图中每个通道的全局信息，并使用两个全连接层来动态地调整每个通道的权重，以增强重要的特征并抑制无关的特征。

分类器采用全局平均池化和全连接层来进行图像分类。全局平均池化将特征图的每个通道降为一个值，然后将这些值传递给全连接层进行分类。这种方法不仅可以减少参数数量，还可以防止过拟合。

## 数据集

在本测试中可以使用ImageNet数据集。

## Mobilenetv2训练

### 环境配置

下载工程代码：

http://developer.hpccube.com/codes/aicomponent/mmclassification-mmcv.git

提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

* 训练镜像：docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
* pip install -r requirements.txt
* cd mmclassification    
* pip install -e .

### 训练

将训练数据解压到data目录下。

训练命令：

    ./mobilenetv2.sh

## 准确率数据

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数 |           精度            |
| :--: | :-----------------------: |
|  8   | top1:0.71764;top5:0.90386 |

### 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/mobilenetv2-mmcv

### 参考

https://github.com/open-mmlab/mmpretrain