# Mobilenetv2

## 论文

MobileNetV2: Inverted Residuals and Linear Bottlenecks

- https://openaccess.thecvf.com/content_cvpr_2018/papers/Sandler_MobileNetV2_Inverted_Residuals_CVPR_2018_paper.pdf

## 模型介绍

MobileNetV2是一种轻量级的卷积神经网络模型，由Google在2018年提出。它是MobileNet系列中的第二个版本，主要用于移动设备和嵌入式设备等资源受限的环境中进行图像分类、目标检测等计算机视觉任务。

![d15a0e56517b4f7284a862f1d6eaef9a](./images/d15a0e56517b4f7284a862f1d6eaef9a.png)



## 模型结构

MobileNetV2的网络结构主要由两部分组成：特征提取层和分类器。

![20231124104337](./images/20231124104337.png)

## 环境配置

### Docker

```python
git clone --recursive http://developer.hpccube.com/codes/modelzoo/mobilenetv2_mmcv.git
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
# <your IMAGE ID>用以上拉取的docker的镜像ID替换
docker run --shm-size 10g --network=host --name=nit-pytorch --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/Mobilenetv2_mmcv:/home/Mobilenetv2_mmcv -it <your IMAGE ID> bash

cd Mobilenetv2_mmcv/mmclassification-mmcv
pip install -r requirements.txt
```

## 数据集

在本测试中可以使用ImageNet数据集。

```
├── meta
├── train
├── val
```

### 训练

将训练数据解压到data目录下。

### 单机8卡

    ./mobilenetv2.sh

## 精度

测试数据使用的是ImageNet数据集，使用的加速卡是DCU Z100L。

| 卡数 |           精度            |
| :--: | :-----------------------: |
|  8   | top1:0.71764;top5:0.90386 |

## result

![img](https://developer.hpccube.com/codes/modelzoo/vit_pytorch/-/raw/master/image/README/1695381570003.png)

## 应用场景

### 算法类别

图像分类

### 热点行业

制造,能源,交通,网安

### 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/mobilenetv2_mmcv

### 参考

https://github.com/open-mmlab/mmpretrain