_base_ = [
    'configs/_base_/models/resnet50.py', 'configs/_base_/datasets/tiny_imagenet_bs32.py',
    'configs/_base_/schedules/imagenet_bs256.py', 'configs/_base_/default_runtime.py'
]

import os

# optimizer
optim_wrapper = dict(
        type='AmpOptimWrapper',
        dtype='bfloat16',
    optimizer=dict(type='SGD', lr=0.1, momentum=0.9, weight_decay=0.0001))

# 自定义hooks，添加ProfilerHook, 只在rank0启用
custom_hooks = [
    dict(type='ProfilerHook', by_epoch=False,
        profile_times=12,
        on_trace_ready=dict(type="log_trace", sort_by="self_cuda_time_total"),
        json_trace_path=f"trace_resnet50_8xb32_bf16.json",
        activity_with_cuda=True,
        schedule=dict(wait=1, warmup=1, active=10, repeat=1))  # 这样的设置是10次
] if os.environ['LOCAL_RANK'] == '0' else []
