<!--Copyright 2024 The HuggingFace Team. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
the License. You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
specific language governing permissions and limitations under the License.
-->

# Attention Processor

An attention processor is a class for applying different types of attention mechanisms.

## AttnProcessor

[[autodoc]] models.attention_processor.AttnProcessor

[[autodoc]] models.attention_processor.AttnProcessor2_0

[[autodoc]] models.attention_processor.AttnAddedKVProcessor

[[autodoc]] models.attention_processor.AttnAddedKVProcessor2_0

[[autodoc]] models.attention_processor.AttnProcessorNPU

[[autodoc]] models.attention_processor.FusedAttnProcessor2_0

## Allegro

[[autodoc]] models.attention_processor.AllegroAttnProcessor2_0

## AuraFlow

[[autodoc]] models.attention_processor.AuraFlowAttnProcessor2_0

[[autodoc]] models.attention_processor.FusedAuraFlowAttnProcessor2_0

## CogVideoX

[[autodoc]] models.attention_processor.CogVideoXAttnProcessor2_0

[[autodoc]] models.attention_processor.FusedCogVideoXAttnProcessor2_0

## CrossFrameAttnProcessor

[[autodoc]] pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.CrossFrameAttnProcessor

## Custom Diffusion

[[autodoc]] models.attention_processor.CustomDiffusionAttnProcessor

[[autodoc]] models.attention_processor.CustomDiffusionAttnProcessor2_0

[[autodoc]] models.attention_processor.CustomDiffusionXFormersAttnProcessor

## Flux

[[autodoc]] models.attention_processor.FluxAttnProcessor2_0

[[autodoc]] models.attention_processor.FusedFluxAttnProcessor2_0

[[autodoc]] models.attention_processor.FluxSingleAttnProcessor2_0

## Hunyuan

[[autodoc]] models.attention_processor.HunyuanAttnProcessor2_0

[[autodoc]] models.attention_processor.FusedHunyuanAttnProcessor2_0

[[autodoc]] models.attention_processor.PAGHunyuanAttnProcessor2_0

[[autodoc]] models.attention_processor.PAGCFGHunyuanAttnProcessor2_0

## IdentitySelfAttnProcessor2_0

[[autodoc]] models.attention_processor.PAGIdentitySelfAttnProcessor2_0

[[autodoc]] models.attention_processor.PAGCFGIdentitySelfAttnProcessor2_0

## IP-Adapter

[[autodoc]] models.attention_processor.IPAdapterAttnProcessor

[[autodoc]] models.attention_processor.IPAdapterAttnProcessor2_0

[[autodoc]] models.attention_processor.SD3IPAdapterJointAttnProcessor2_0

## JointAttnProcessor2_0

[[autodoc]] models.attention_processor.JointAttnProcessor2_0

[[autodoc]] models.attention_processor.PAGJointAttnProcessor2_0

[[autodoc]] models.attention_processor.PAGCFGJointAttnProcessor2_0

[[autodoc]] models.attention_processor.FusedJointAttnProcessor2_0

## LoRA

[[autodoc]] models.attention_processor.LoRAAttnProcessor

[[autodoc]] models.attention_processor.LoRAAttnProcessor2_0

[[autodoc]] models.attention_processor.LoRAAttnAddedKVProcessor

[[autodoc]] models.attention_processor.LoRAXFormersAttnProcessor

## Lumina-T2X

[[autodoc]] models.attention_processor.LuminaAttnProcessor2_0

## Mochi

[[autodoc]] models.attention_processor.MochiAttnProcessor2_0

[[autodoc]] models.attention_processor.MochiVaeAttnProcessor2_0

## Sana

[[autodoc]] models.attention_processor.SanaLinearAttnProcessor2_0

[[autodoc]] models.attention_processor.SanaMultiscaleAttnProcessor2_0

[[autodoc]] models.attention_processor.PAGCFGSanaLinearAttnProcessor2_0

[[autodoc]] models.attention_processor.PAGIdentitySanaLinearAttnProcessor2_0

## Stable Audio

[[autodoc]] models.attention_processor.StableAudioAttnProcessor2_0

## SlicedAttnProcessor

[[autodoc]] models.attention_processor.SlicedAttnProcessor

[[autodoc]] models.attention_processor.SlicedAttnAddedKVProcessor

## XFormersAttnProcessor

[[autodoc]] models.attention_processor.XFormersAttnProcessor

[[autodoc]] models.attention_processor.XFormersAttnAddedKVProcessor

## XLAFlashAttnProcessor2_0

[[autodoc]] models.attention_processor.XLAFlashAttnProcessor2_0
