<!--Copyright 2025 The HuggingFace Team. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
the License. You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
specific language governing permissions and limitations under the License.
-->

# 安装

在你正在使用的任意深度学习框架中安装 🤗 Diffusers 。

🤗 Diffusers已在Python 3.8+、PyTorch 1.7.0+和Flax上进行了测试。按照下面的安装说明，针对你正在使用的深度学习框架进行安装：

- [PyTorch](https://pytorch.org/get-started/locally/) installation instructions.
- [Flax](https://flax.readthedocs.io/en/latest/) installation instructions.

## 使用pip安装

你需要在[虚拟环境](https://docs.python.org/3/library/venv.html)中安装 🤗 Diffusers 。

如果你对 Python 虚拟环境不熟悉，可以看看这个[教程](https://packaging.python.org/guides/installing-using-pip-and-virtual-environments/).

在虚拟环境中，你可以轻松管理不同的项目，避免依赖项之间的兼容性问题。

首先，在你的项目目录下创建一个虚拟环境：

```bash
python -m venv .env
```

激活虚拟环境：

```bash
source .env/bin/activate
```

现在，你就可以安装 🤗 Diffusers了！使用下边这个命令：

**PyTorch**

```bash
pip install diffusers["torch"]
```

**Flax**

```bash
pip install diffusers["flax"]
```

## 从源代码安装

在从源代码安装 `diffusers` 之前，确保你已经安装了 `torch` 和 `accelerate`。

`torch`的安装教程可以看 `torch` [文档](https://pytorch.org/get-started/locally/#start-locally).

安装 `accelerate`

```bash
pip install accelerate
```

从源码安装 🤗 Diffusers 需要使用以下命令:

```bash
pip install git+https://github.com/huggingface/diffusers
```

这个命令安装的是最新的 `main`版本，而不是最近的`stable`版。
`main`是一直和最新进展保持一致的。比如，上次发布的正式版中有bug，在`main`中可以看到这个bug被修复了，但是新的正式版此时尚未推出。
但是这也意味着 `main`版本不保证是稳定的。

我们努力保持`main`版本正常运行，大多数问题都能在几个小时或一天之内解决

如果你遇到了问题，可以提 [Issue](https://github.com/huggingface/transformers/issues)，这样我们就能更快修复问题了。

## 可修改安装

如果你想做以下两件事，那你可能需要一个可修改代码的安装方式：

* 使用 `main`版本的源代码。
* 为 🤗 Diffusers 贡献，需要测试代码中的变化。

使用以下命令克隆并安装 🤗 Diffusers:

```bash
git clone https://github.com/huggingface/diffusers.git
cd diffusers
```

**PyTorch**

```sh
pip install -e ".[torch]"
```

**Flax**

```sh
pip install -e ".[flax]"
```

这些命令将连接到你克隆的版本库和你的 Python 库路径。
现在，不只是在通常的库路径，Python 还会在你克隆的文件夹内寻找包。
例如，如果你的 Python 包通常安装在 `~/anaconda3/envs/main/lib/python3.10/Site-packages/`，Python 也会搜索你克隆到的文件夹。`~/diffusers/`。

<Tip warning={true}>

如果你想继续使用这个库，你必须保留 `diffusers` 文件夹。

</Tip>


现在你可以用下面的命令轻松地将你克隆的 🤗 Diffusers 库更新到最新版本。

```bash
cd ~/diffusers/
git pull
```

你的Python环境将在下次运行时找到`main`版本的 🤗 Diffusers。

## 注意 Telemetry 日志

我们的库会在使用`from_pretrained()`请求期间收集 telemetry 信息。这些数据包括Diffusers和PyTorch/Flax的版本，请求的模型或管道类，以及预训练检查点的路径（如果它被托管在Hub上的话）。
这些使用数据有助于我们调试问题并确定新功能的开发优先级。
Telemetry 数据仅在从 HuggingFace Hub 中加载模型和管道时发送，而不会在本地使用期间收集。

我们知道，并不是每个人都想分享这些的信息，我们尊重您的隐私，
因此您可以通过在终端中设置 `DISABLE_TELEMETRY` 环境变量从而禁用 Telemetry 数据收集：


Linux/MacOS :
```bash
export DISABLE_TELEMETRY=YES
```

Windows :
```bash
set DISABLE_TELEMETRY=YES
```