#export GLUE_DIR=./glue
#export BERT_DIR=./bert_en_cased_L-12_H-768_A-12_1/assets
#export TASK_NAME=MNLI
#export OUTPUT_DIR=./glue_finetuning
#python ../data/create_finetuning_data.py \
# --input_data_dir=${GLUE_DIR}/${TASK_NAME}/ \
# --vocab_file=${BERT_DIR}/vocab.txt \
# --train_data_output_path=${OUTPUT_DIR}/${TASK_NAME}_train.tf_record \
# --eval_data_output_path=${OUTPUT_DIR}/${TASK_NAME}_eval.tf_record \
# --meta_data_file_path=${OUTPUT_DIR}/${TASK_NAME}_meta_data \
# --fine_tuning_task_type=classification --max_seq_length=128 \
# --classification_task_name=${TASK_NAME}
#

export BERT_DIR=./bert_en_cased_L-12_H-768_A-12_1/assets
export MODEL_DIR=./model_dir
export GLUE_DIR=./glue_finetuning
export TASK=MNLI
export HIP_VISIBLE_DEVICES=0,1,2,3
python3 run_classifier.py \
  --mode='train_and_eval' \
  --input_meta_data_path=${GLUE_DIR}/${TASK}_meta_data \
  --train_data_path=${GLUE_DIR}/${TASK}_train.tf_record \
  --eval_data_path=${GLUE_DIR}/${TASK}_eval.tf_record \
  --bert_config_file=${BERT_DIR}/bert_config.json \
  --train_batch_size=4 \
  --eval_batch_size=4 \
  --steps_per_loop=1 \
  --learning_rate=2e-5 \
  --num_train_epochs=3 \
  --model_dir=${MODEL_DIR} \
  --num_gpus=4 \
  --distribution_strategy=multi_worker_mirrored
#  --dtype=fp16 \
#  --fp16_implementation=graph_rewrite \
#  --distribution_strategy=mirrored /MultiWorkerMirroredStrategy
  #--init_checkpoint=${BERT_DIR}/bert_model.ckpt \
  #--enable_xla=true \
