#!/bin/bash
set -e

# 清理构建目录和旧的分发文件
rm -rf build
rm -rf dist
rm -rf *.egg-info
rm -rf ktransformers/ktransformers_ext/build
rm -rf ktransformers/ktransformers_ext/cuda/build
rm -rf ktransformers/ktransformers_ext/cuda/dist
rm -rf ktransformers/ktransformers_ext/cuda/*.egg-info
echo "初始化Git子模块..."
git submodule update --init --recursive

export CMAKE_BUILD_PARALLEL_LEVEL=32

echo "构建ktransformers wheel包"

mkdir -p dist

KTRANSFORMERS_FORCE_BUILD=TRUE pip wheel . -w dist --no-build-isolation --no-deps

echo "生成的wheel包位于："
ls -l dist/*.whl

echo "构建成功！wheel包已生成在dist目录"

