# Ollama

## 安装

### 环境准备

#### Docker

    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310

    docker run --shm-size 30g --network=host --name=ollama --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash


### 本仓库

本仓库仅提供代码修改时的参考，请勿直接使用，官方版本0.1.43已测可用。
本仓库也提供了已测试通过的`Dockerfile`（Z100），在`ollama_build.zip`中，如需适配其他平台需要按照下述文档对`Dockerfile`进行修改，主要为`AMDGPU_TARGETS=当前设备型号（如：gfx906，gfx928等）；HSA_OVERRIDE_GFX_VERSION=设备型号（如: gfx906对应9.0.6；gfx928对应9.2.8）`。

### 官方版本下载及修改

1、下载源码

    git clone https://github.com/ollama/ollama.git  
    cd ollama
    git submodule init
    git submodule update

注意：上述命令将下载最新版本，可以在[官网](https://github.com/ollama/ollama/releases)查找其他版本。

2、修改源码

- 跳过git仓库检查及链接库检查，可在`llm/generate/gen_linux.sh`中修改
- 修改`llm/llama.cpp`中`cu`文件，在相应函数中加入`__launch_bounds__(1024)`
- 注释`llm/llama.cpp/requirements`中所有有关`torch`的下载部分
- 修改`gpu/amd_linux.go`中`DriverVersionFile`及`ROCmLibGlobs`值，具体参考本仓库相应文件。

3、安装依赖包

    cd llm/llama.cpp
    pip install -r requirements.txt

### 编译

#### 环境设置
    export AMDGPU_TARGETS=当前设备型号（如：gfx906，gfx928等）
    export HSA_OVERRIDE_GFX_VERSION=设备型号（如: gfx906对应9.0.6；gfx928对应9.2.8）
    export HIP_PATH=/opt/dtk/hip
    export ROCM_PATH=/opt/dtk
    export CMAKE_PREFIX_PATH=/lib/cmake/amd_comgr/:$CMAKE_PREFIX_PATH
    export CMAKE_PREFIX_PATH=/opt/dtk/lib64/cmake/amd_comgr:$CMAKE_PREFIX_PATH
    export LIBRARY_PATH=/opt/dtk/llvm/lib/clang/15.0.0/lib/linux/:$LIBRARY_PATH
    export HIP_VISIBLE_DEVICES=所有设备号（0,1,2,3,4,5,6,...）/选择设备号（0,1）

注意：仅在dtk24.04+ 版本可用，其他版本需进行相应修改，更多设备型号设置请参考[列表](https://salsa.debian.org/rocm-team/community/team-project/-/wikis/supported-gpu-list)。

安装go

https://golang.google.cn/dl/

    # 请替换[]中下载的go文件
    tar -C /usr/local -xzf [go-xxxx.tar.gz]
    export PATH=$PATH:/usr/local/go/bin

    # 修改go下载源，提升速度（按需设置）
    go env -w GO111MODULE=on
    go env -w GOPROXY=https://goproxy.cn,direct

安装cmake(3.29版本可用)

https://cmake.org/download/

解压安装后设置

    export PATH=/path/to/cmake/bin:$PATH

gcc升级（如需，gcc - 7.3.1可正常编译）

    yum install centos-release-scl
    yum install devtoolset-9-gcc*
    scl enable devtoolset-9 bash

    # 如果有其他版本gcc需要进行卸载
    rpm -q gcc
    rpm -e 上一步的输出 （需要卸载所有依赖项）

#### 运行编译

    cd llm/generate && bash gen_linux.sh
    cd ../.. && go build

## 快速应用

    ./ollama serve &
    export HIP_VISIBLE_DEVICES=0  （选择可用设备，可通过上条命令输出结果查看）
    ./ollama run qwen2:7b-instruct-fp16

更多使用方式请参考[原项目](https://github.com/ollama/ollama)。

注意：每次运行前请检查环境变量`HSA_OVERRIDE_GFX_VERSION`是否正确设置。

## Release Notes

1、在DCU平台上，该项目对fp16(qwen2-7b, llama3-8b), q8(mistral-7b)测试通过；

2、在DCU平台上，该项目对更极端的量化模型支持需要进一步优化，请选择q8以及上的模型。

## 参考资料

* https://github.com/ollama/ollama
* https://github.com/ggerganov/llama.cpp
