# <div align="center"><strong>Ollama</strong></div>

## 简介

1 Ollama是以llama.cpp为后端的前端大模型推理框架，可快速部署主流模型。

## 安装

### 1、使用源码编译方式安装

#### 环境准备

##### Docker

```bash
docker pull docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-py3.10-dtk24.04.3-ubuntu20.04

docker run -i -t -d  --device=/dev/kfd --privileged --network=host --device=/dev/dri --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home  -v /opt/hyhal:/opt/hyhal:ro -v --group-add video --shm-size 16G --name {容器名} {镜像ID}
```

1、下载源码

```bash
git clone -b 0.4.7 http://developer.sourcefind.cn/codes/OpenDAS/ollama.git --depth=1
cd ollama
```

#### 编译

##### 安装go

```bash
wget https://go.dev/dl/go1.22.8.linux-amd64.tar.gz
tar -C /usr/local -xzf go1.22.8.linux-amd64.tar.gz
export PATH=$PATH:/usr/local/go/bin

# 修改go下载源，提升速度（按需设置）
go env -w GOPROXY=https://goproxy.cn,direct
```

##### 运行编译

```bash
export LIBRARY_PATH=/opt/dtk/lib:$LIBRARY_PATH
make -j 16
go build .
```

## 运行

```bash
export HSA_OVERRIDE_GFX_VERSION=设备型号（如: gfx906对应9.0.6；gfx928对应9.2.8）
export LD_LIBRARY_PATH=/path/to/ollama/llama/build/linux-amd64/runners/rocm:$LD_LIBRARY_PATH (path/to换成到自己ollama路径)
export HIP_VISIBLE_DEVICES=所有设备号（0,1,2,3,4,5,6,...）/选择设备号
./ollama serve  （选择可用设备，可通过上条命令输出结果查看）
./ollama run llama3.1
```

更多使用方式请参考[原项目](https://github.com/ollama/ollama)。

注意：每次运行前请检查环境变量`HSA_OVERRIDE_GFX_VERSION`是否正确设置。

## 参考资料

* https://github.com/ollama/ollama
