# data\_process

## 简介

由于源2.0 是在 Megatron 框架下训练与微调的，因此在训练之前需要将文本语料转换为token id 并存储在 .bin文件中。我们提供的 preprocess\_data\_yuan.py 脚本可以高效地将文本转换为 token id，是专门为预处理中文语料而设计的。该脚本可在 "tools "目录下找到。

preprocess\_data\_yuan.py脚本中的主要参数说明如下：

| 参数名称               | 参数描述                                                                                    |
| ------------------ | --------------------------------------------------------------------------------------- |
| `--input`          | 存储训练数据集的路径，数据集应存储为 .txt 文件。注意：即使仅有一个.txt文件需要处理，此处输入的也应该是数据存储路径（文件夹），不是.txt的路径。          |
| `--data-idx`       | 此参数设置训练数据集的索引。如果只有一个数据集需要转换，则 --data-idx 应设置为 "0"。如果有多个训练数据集，则设置为 "0-n"，其中 n 是训练数据集的数量。 |
| `--tokenizer_path` | 导入tokenizer文件的路径。                                                                       |
| `--output_path`    | 完成预处理后的数据集的输出路径，每个数据集将创建一个 .idx 文件和一个 .bin 文件。                                          |



## 数据集

数据集中的样本应该用"\n"分隔，在每个样本中，"\n"应该替换为"\<n>"，因此数据集中的每一行都是一个样本。程序在预处理时会把"\<n>"替换回"\n"。

对于用于微调 Yuan2.0 的数据集，应在Instruction与Response之间加上"\<sep>"。

以下是两条微调数据集的样例：

```text
John买了3件衬衫，每件售价为20美元。此外，他还需要支付所有商品的10%税款。他总共支付了多少钱？<sep>John购买的3件衬衫的总价为3 \times 20 = 60美元。<n>所有商品的税款为总价的10%，即60 \times 0.1 = 6美元。<n>因此，John总共支付的钱数为60 + 6 = 66美元。
每年，Dani作为赢得亚马逊季度最佳买家的奖励，会得到4个一对裤子（每对裤子2条）。如果初始时他有50条裤子，计算出5年后他将拥有多少条裤子。<sep>每年Dani会得到4 \times 2 = 8条裤子，因此5年后他将得到8 \times 5 = 40条裤子。<n>那么，5年后他总共拥有的裤子数量为初始时的50条加上5年内得到的40条，即50 + 40 = 90条裤子。<n>因此，5年后他将拥有90条裤子。
```



## 使用

运行一下命令开始预处理数据：

```text
python ./tools/preprocess_data_yuan.py --input '<Specify path>' --data-idx '0-42' --tokenizer_path './tokenizer' --output_path '<Specify path>'
```

如果数据集已被处理，即其 .idx 文件和 .bin 文件已存在于"-output\_path"（输出路径）中，程序将跳过该数据集。

