# yolox_mmcv
## 论文
`YOLOX: Exceeding YOLO Series in 2021`<br>
[论文链接](https://arxiv.org/abs/2107.08430)
## 模型结构
YoloX由旷视科技开源，以YoloV3(Darknet53作为backbone)作为基线，在样本增样，样本匹配，模型输出头等进行了优化 [Decoupled Head，Data Aug，Anchor Free,SimOTA]
![model_structure.jpg](resources%2Fmodel_structure.jpg)
## 算法原理
宏观架构上在yolov3的基础之上，进行优化，通过对检测头解耦，样本匹配，训练策略等多个方面进行了改进，从而提升了模型性能和收敛速度
对构建单元进行了更新
![head.jpg](resources%2Fhead.jpg)
## 环境配置
### Docker（方法一）

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-centos7.6-dtk-23.04.1-py38-latest
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
cd /path/workspace/
pip install mmdet==3.2.0 -i https://mirrors.aliyun.com/pypi/simple/
```
### Dockerfile（方法二）
```
cd ./docker
docker build --no-cache -t mmdet:3.0 .
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
cd /path/workspace/
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/
```
DTK软件栈: dtk23.04.1
python: python3.8
torch: 1.13.1
torchvision: 0.14.1
mmcv: 2.0.0

```

Tips：以上dtk软件栈、python、torch、mmcv等DCU相关工具版本需要严格一一对应

2、其他非特殊库直接按照requirements.txt安装

```
cd workspace/
pip install mmdet==3.2.0 -i https://mirrors.aliyun.com/pypi/simple/
```

## 数据集
COCO2017

[训练数据](http://images.cocodataset.org/zips/train2017.zip)

[验证数据](http://images.cocodataset.org/zips/val2017.zip)

[测试数据](http://images.cocodataset.org/zips/test2017.zip)

[标签数据](https://github.com/ultralytics/yolov5/releases/download/v1.0/coco2017labels.zip)

数据集的目录结构如下：

```
├── images 
│   ├── train2017
│   ├── val2017
│   ├── test2017
├── labels
│   ├── train2017
│   ├── val2017
├── annotations
│   ├── instances_val2017.json
├── LICENSE
├── README.txt 
├── test-dev2017.txt
├── train2017.txt
├── val2017.txt

```

## 训练
- 如需要变更数据集目录 请修改 configs/yolox/yolox_s_8xb8-300e_coco.py 下的 data_root
```python
bash ./train.sh
```
## 推理
- 可使用官方模型权重进行推理，也可使用自己训练模型权重进行推理
- 这里以官方模型推理举例[[下载地址：yolox_s_8x8_300e_coco_20211121_095711-4592a793.pth](https://download.openmmlab.com/mmdetection/v2.0/yolox/yolox_s_8x8_300e_coco/yolox_s_8x8_300e_coco_20211121_095711-4592a793.pth)]
```python
# 官方推理代码
python demo/image_demo.py demo/demo.jpg ./configs/yolox/yolox_s_8xb8-300e_coco.py --weights yolox_s_8x8_300e_coco_20211121_095711-4592a793.pth --device cuda
```
## result
![result](./resources/result.jpg)
### 精度
|   模型名称   | batchsize | amp混精 |  精度  |
|:--------:|:---------:|:-----:|:----:|
| yolox-s |    256    |  off  | 40.3 |
| yolox-s  |    256    |  on   | 40.1 |
## 应用场景
### 算法类别
`目标检测`
### 热点应用行业
`金融,交通,教育`
## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/yolox_mmcv
## 参考资料
- https://github.com/open-mmlab/mmdetection/tree/v3.2.0
