#ifndef __DETECTOR_YOLOV9_H__
#define __DETECTOR_YOLOV9_H__

#include <migraphx/program.hpp>
#include <CommonDefinition.h>

namespace migraphxSamples
{

    typedef struct _YOLOV9Parameter
    {
        int numberOfClasses;
        float confidenceThreshold;
        float nmsThreshold;

    } YOLOV9Parameter;

    class DetectorYOLOV9
    {
    public:
        DetectorYOLOV9();

        ~DetectorYOLOV9();

        ErrorCode Initialize(InitializationParameterOfDetector initializationParameterOfDetector, bool dynamic);

        ErrorCode Detect(const cv::Mat &srcImage, std::vector<std::size_t> &relInputShape, std::vector<ResultOfDetection> &resultsOfDetection, bool dynamic);

    private:
        cv::FileStorage configurationFile;

        migraphx::program net;
        cv::Size inputSize;
        std::string inputName;
        std::string modelPath;
        migraphx::shape inputShape;

        bool useFP16;
        std::vector<std::string> classNames;

        YOLOV9Parameter yolov9Parameter;
    };

}

#endif
