# YOLOv9

## 论文

https://arxiv.org/abs/2402.13616

## 模型结构

YOLOv9引入了可编程梯度信息 (PGI) 和广义高效层聚合网络 (GELAN) 等开创性技术，标志着实时目标检测领域的重大进步。

<img src=./Doc/yolov9-model.png style="zoom:100%;" align=middle>

## 算法原理

YOLOv9从可逆函数角度理论上分析了现有的CNN架构，基于这种分析，YOLOv9作者还设计了PGI和辅助可逆分支，并取得了优秀的结果；
YOLOv9用到的PGI解决了深度监督只能用于极深的神经网络架构的问题，因此使得新的轻量级架构才更适合落地；
YOLOv9中设计的GELAN仅使用传统卷积，就能实现比基于最先进技术的深度可分卷积设计更高的参数使用率，同时展现出轻量级、快速和精确的巨大优势；
基于所提出的PGI和GELAN，YOLOv9在MS COCO数据集上的性能在所有方面都大大超过了现有的实时目标检测器。

<img src=./Doc/pgi.png style="zoom:100%;" align=middle>

PGI主要包括三个组成部分，即：主分支, 辅助可逆分支, 多级辅助信息。PGI推理过程仅使用主分支，因此不需要任何额外的推理成本。

<img src=./Doc/gelan.png style="zoom:100%;" align=middle>
YOLOv9提出了新网络架构——GELAN。GELAN通过结合两种神经网络架构，即结合用梯度路径规划（CSPNet）和（ELAN）设计了一种广义的高效层聚合网络（GELAN）；GELAN综合考虑了轻量级、推理速度和准确度。GELAN整体架构如上图所示。YOLOv9将ELAN的能力进行了泛化，原始ELAN仅使用卷积层的堆叠，而GELAN可以使用任何计算块作为基础Module。

## 环境配置

### Docker（方法一）

拉取镜像：

```shell
docker pull image.sourcefind.cn:5000/dcu/admin/base/migraphx:4.0.0-centos7.6-dtk23.04.1-py38-latest
```

创建并启动容器：

```shell
docker run --shm-size 16g --network=host --name=yolov9_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/yolov9_migraphx:/home/yolov9_migraphx -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

### Dockerfile（方法二）

```shell
cd ./docker
docker build --no-cache -t yolov9_migraphx:2.0 .

docker run --shm-size 16g --network=host --name=yolov9_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/yolov9_migraphx:/home/yolov9_migraphx -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 数据集

根据提供的样本数据，进行目标检测。

## 推理

### Python版本推理

下面介绍如何运行Python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

#### 设置环境变量

```shell
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

#### 安装依赖

```shell
# 进入python示例目录
cd <path_to_yolov9_migraphx>/Python

# 安装依赖
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
```

#### 运行示例

YOLOv9模型的推理示例程序是YoloV9_infer_migraphx.py，使用如下命令运行该推理示例：


1. 静态推理

```shell
python YoloV9_infer_migraphx.py --staticInfer
```

2. 动态推理

```shell
python YoloV9_infer_migraphx.py --dynamicInfer
```

### C++版本推理

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。


#### 构建工程

```shell
cd <path_to_yolov9_migraphx>
rbuild build -d depend
```

#### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

```shell
export LD_LIBRARY_PATH=<path_to_yolov9_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```shell
source ~/.bashrc
```

#### 运行示例

YOLOv9示例程序编译成功后，执行如下指令运行该示例：

```shell
# 进入yolov9 migraphx工程根目录
cd <path_to_yolov9_migraphx>

# 进入build目录
cd build/
```

1. 静态推理

```shell
./YOLOV9 0
```

2. 动态推理

```shell
./YOLOV9 1
```

## result

### Python版本

静态推理：

python程序运行结束后，会在当前目录生成YOLOV9静态推理检测结果可视化图像。

<img src="./Resource/Images/Result_python.jpg" alt="Result" style="zoom: 50%;" />

动态推理：

python程序运行结束后，会在当前目录生成YOLOv9动态推理检测结果可视化图像。

<img src="./Resource/Images/Result0_python.jpg" alt="Result0" style="zoom: 50%;" />

<img src="./Resource/Images/Result1_python.jpg" alt="Result1" style="zoom: 50%;" />

### C++版本

静态推理：

C++程序运行结束后，会在build目录生成YOLOV9静态推理检测结果可视化图像。

<img src="./Resource/Images/Result.jpg" alt="Result" style="zoom:50%;" />

动态推理：

C++程序运行结束后，会在build目录生成YOLOv9动态shape推理检测结果可视化图像。

<img src="./Resource/Images/Result0.jpg" alt="Result0" style="zoom:50%;" />

<img src="./Resource/Images/Result1.jpg" alt="Result1" style="zoom:50%;" />

### 精度

无

## 应用场景

### 算法类别

`目标检测`

### 热点应用行业

`交通`,`教育`,`化工`

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/yolov9_migraphx

## 参考资料

https://github.com/WongKinYiu/yolov9
