---
comments: true
description: Руководство по проверке моделей YOLOv8. Узнайте, как оценить производительность ваших моделей YOLO, используя параметры проверки и метрики с примерами на Python и CLI.
keywords: Ultralytics, YOLO Документация, YOLOv8, проверка, оценка модели, гиперпараметры, точность, метрики, Python, CLI
---

# Валидация моделей с Ultralytics YOLO

<img width="1024" src="https://github.com/ultralytics/assets/raw/main/yolov8/banner-integrations.png" alt="Ultralytics YOLO экосистема и интеграции">

## Введение

Валидация является критически важным этапом в процессе машинного обучения, позволяющим оценить качество ваших обученных моделей. Режим Val в Ultralytics YOLOv8 обеспечивает набор инструментов и метрик для оценки производительности ваших моделей по обнаружению объектов. Это руководство служит полным ресурсом для понимания того, как эффективно использовать режим Val, чтобы обеспечить точность и надежность ваших моделей.

## Зачем проверять с Ultralytics YOLO?

Вот почему использование режима Val YOLOv8 выгодно:

- **Точность:** Получите точные метрики, такие как mAP50, mAP75 и mAP50-95, для всесторонней оценки вашей модели.
- **Удобство:** Используйте встроенные функции, которые запоминают настройки обучения, упрощая процесс валидации.
- **Гибкость:** Проверяйте вашу модель с использованием тех же или разных наборов данных и размеров изображений.
- **Настройка гиперпараметров:** Используйте метрики проверки для дополнительной настройки вашей модели для лучшей производительности.

### Основные функции режима Val

Вот некоторые заметные функции, предлагаемые режимом Val YOLOv8:

- **Автоматизированные настройки:** Модели запоминают свои конфигурации обучения для простой валидации.
- **Поддержка множества метрик:** Оцените вашу модель, основываясь на ряде метрик точности.
- **CLI и Python API:** Выберите интерфейс командной строки или Python API в зависимости от вашего предпочтения для проверки.
- **Совместимость данных:** Бесперебойно работает с наборами данных, используемыми во время фазы обучения, а также с пользовательскими наборами данных.

!!! Tip "Совет"

    * Модели YOLOv8 автоматически запоминают свои настройки обучения, так что вы можете легко проверить модель с тем же размером изображения и на оригинальном наборе данных, просто используя `yolo val model=yolov8n.pt` или `model('yolov8n.pt').val()`

## Примеры использования

Проверьте точность обученной модели YOLOv8n на наборе данных COCO128. Аргументы передавать не требуется, так как `модель` сохраняет `данные` и аргументы в качестве атрибутов модели. См. раздел Аргументы ниже для полного списка аргументов экспорта.

!!! Example "Пример"

    === "Python"

        ```python
        from ultralytics import YOLO

        # Загрузка модели
        model = YOLO('yolov8n.pt')  # загрузить официальную модель
        model = YOLO('path/to/best.pt')  # загрузить пользовательскую модель

        # Проверка модели
        metrics = model.val()  # аргументы не нужны, набор данных и настройки запомнены
        metrics.box.map    # map50-95
        metrics.box.map50  # map50
        metrics.box.map75  # map75
        metrics.box.maps   # список содержит map50-95 каждой категории
        ```
    === "CLI"

        ```bash
        yolo detect val model=yolov8n.pt  # проверить официальную модель
        yolo detect val model=path/to/best.pt  # проверить пользовательскую модель
        ```

## Аргументы

Настройки проверки для моделей YOLO относятся к различным гиперпараметрам и конфигурациям, используемым для оценки производительности модели на наборе данных для проверки. Эти настройки могут влиять на производительность, скорость и точность модели. Некоторые общие параметры проверки YOLO включают размер пакета, частоту проведения проверки во время обучения и метрики, используемые для оценки производительности модели. Другие факторы, которые могут влиять на процесс проверки, включают размер и состав набора данных для проверки и конкретную задачу, для которой используется модель. Важно тщательно настроить и провести эксперименты с этими параметрами, чтобы убедиться, что модель хорошо работает на наборе данных для проверки и для обнаружения и предотвращения переобучения.

| Ключ          | Значение | Описание                                                                                |
|---------------|----------|-----------------------------------------------------------------------------------------|
| `data`        | `None`   | путь к файлу данных, например, coco128.yaml                                             |
| `imgsz`       | `640`    | размер входных изображений как целое число                                              |
| `batch`       | `16`     | количество изображений в пакете (-1 для AutoBatch)                                      |
| `save_json`   | `False`  | сохранить результаты в файл JSON                                                        |
| `save_hybrid` | `False`  | сохранить гибридную версию меток (метки + дополнительные предсказания)                  |
| `conf`        | `0.001`  | порог уверенности объекта для обнаружения                                               |
| `iou`         | `0.6`    | порог пересечения по объединению (IoU) для NMS (нечеткое сравнение)                     |
| `max_det`     | `300`    | максимальное количество обнаружений на изображение                                      |
| `half`        | `True`   | использовать полупрецизионность (FP16)                                                  |
| `device`      | `None`   | устройство для выполнения, например, cuda device=0/1/2/3 или device=cpu                 |
| `dnn`         | `False`  | использовать OpenCV DNN для ONNX инференции                                             |
| `plots`       | `False`  | показывать графики во время обучения                                                    |
| `rect`        | `False`  | прямоугольная валидация с коллекцией каждого пакета для минимальной паддинга            |
| `split`       | `val`    | раздел набора данных для использования в валидации, например, 'val', 'test' или 'train' |
|
