---
comments: true
description: Узнайте, как использовать режим предсказаний YOLOv8 для различных задач. Изучите различные источники вывода, такие как изображения, видео и форматы данных.
keywords: Ultralytics, YOLOv8, режим предсказаний, источники вывода, задачи предсказания, режим потоковой передачи, обработка изображений, обработка видео, машинное обучение, искусственный интеллект
---

# Прогнозирование моделью Ultralytics YOLO

<img width="1024" src="https://github.com/ultralytics/assets/raw/main/yolov8/banner-integrations.png" alt="Экосистема и интеграции Ultralytics YOLO">

## Введение

В мире машинного обучения и компьютерного зрения процесс извлечения информации из визуальных данных называется 'выводом' или 'предсказанием'. Ultralytics YOLOv8 предлагает мощную функцию, известную как **режим предсказаний**, который предназначен для высокопроизводительного реального времени вывода на широкий спектр источников данных.

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/QtsI0TnwDZs?si=ljesw75cMO2Eas14"
    title="Проигрыватель видео YouTube" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>Смотреть:</strong> Как извлечь результаты из модели Ultralytics YOLOv8 для пользовательских проектов.
</p>

## Прикладные области

|                                                          Производство                                                           |                                                             Спорт                                                             |                                                          Безопасность                                                           |
|:-------------------------------------------------------------------------------------------------------------------------------:|:-----------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
| ![Обнаружение автозапчастей](https://github.com/RizwanMunawar/ultralytics/assets/62513924/a0f802a8-0776-44cf-8f17-93974a4a28a1) | ![Обнаружение футболистов](https://github.com/RizwanMunawar/ultralytics/assets/62513924/7d320e1f-fc57-4d7f-a691-78ee579c3442) | ![Обнаружение падения людей](https://github.com/RizwanMunawar/ultralytics/assets/62513924/86437c4a-3227-4eee-90ef-9efb697bdb43) |
|                                                    Обнаружение автозапчастей                                                    |                                                    Обнаружение футболистов                                                    |                                                    Обнаружение падения людей                                                    |

## Почему стоит использовать Ultralytics YOLO для вывода?

Вот почему вам следует рассмотреть режим предсказаний YOLOv8 для ваших различных потребностей в выводе:

- **Универсальность:** Возможность делать выводы по изображениям, видео и даже потоковым трансляциям.
- **Производительность:** Разработан для обработки данных в реальном времени без потери точности.
- **Простота использования:** Интуитивно понятные интерфейсы Python и CLI для быстрого развертывания и тестирования.
- **Высокая настраиваемость:** Различные настройки и параметры для настройки поведения модели вывода в соответствии с вашими конкретными требованиями.

### Ключевые особенности режима предсказаний

Режим предсказаний YOLOv8 разработан, чтобы быть надежным и универсальным, он включает в себя:

- **Совместимость с несколькими источниками данных:** независимо от того, представлены ли ваши данные в виде отдельных изображений, коллекции изображений, видеофайлов или потокового видео, режим предсказаний покрывает все это.
- **Режим потоковой передачи:** Используйте функцию потоковой передачи для создания генератора объектов `Results`, экономящего память. Активируйте это, установив `stream=True` в методе вызова предиктора.
- **Пакетная обработка:** Возможность обрабатывать несколько изображений или видеокадров за один пакет, что дополнительно ускоряет время вывода.
- **Дружественная интеграция:** Легко интегрируется с существующими данными и другими программными компонентами благодаря гибкому API.

Модели Ultralytics YOLO возвращают либо список объектов `Results`, либо генератор объектов `Results` в Python, экономящий память, когда `stream=True` передается в модель во время вывода:

!!! Example "Предсказание"

    === "Вернуть список с `stream=False`"
        ```python
        from ultralytics import YOLO

        # Загрузка модели
        model = YOLO('yolov8n.pt')  # предварительно обученная модель YOLOv8n

        # Пакетный вывод на список изображений
        results = model(['im1.jpg', 'im2.jpg'])  # вернуть список объектов Results

        # Обработка списка результатов
        for result in results:
            boxes = result.boxes  # Объект Boxes для вывода bbox
            masks = result.masks  # Объект Masks для вывода масок сегментации
            keypoints = result.keypoints  # Объект Keypoints для вывода поз
            probs = result.probs  # Объект Probs для вывода вероятностей классификации
        ```

    === "Вернуть генератор с `stream=True`"
        ```python
        from ultralytics import YOLO

        # Загрузка модели
        model = YOLO('yolov8n.pt')  # предварительно обученная модель YOLOv8n

        # Пакетный вывод на список изображений
        results = model(['im1.jpg', 'im2.jpg'], stream=True)  # вернуть генератор объектов Results

        # Обработка генератора результатов
        for result in results:
            boxes = result.boxes  # Объект Boxes для вывода bbox
            masks = result.masks  # Объект Masks для вывода масок сегментации
            keypoints = result.keypoints  # Объект Keypoints для вывода поз
            probs = result.probs  # Объект Probs для вывода вероятностей классификации
        ```

## Источники вывода

YOLOv8 может обрабатывать различные типы входных источников для вывода, как показано в таблице ниже. Источники включают статические изображения, видеопотоки и различные форматы данных. В таблице также указано, можно ли использовать каждый источник в режиме потоковой передачи с аргументом `stream=True` ✅. Режим потоковой передачи полезен для обработки видео или живых трансляций, так как создает генератор результатов вместо загрузки всех кадров в память.

!!! Tip "Совет"

    Используйте `stream=True` для обработки длинных видеороликов или больших наборов данных для эффективного управления памятью. Когда `stream=False`, результаты для всех кадров или точек данных хранятся в памяти, что может быстро накопиться и вызвать ошибки переполнения памяти для больших входов. В отличие от этого, `stream=True` использует генератор, который хранит в памяти результаты только текущего кадра или точки данных, значительно сокращая потребление памяти и предотвращая проблемы с переполнением памяти.

| Источник        | Аргумент                                   | Тип              | Заметки                                                                                                       |
|-----------------|--------------------------------------------|------------------|---------------------------------------------------------------------------------------------------------------|
| изображение     | `'image.jpg'`                              | `str` или `Path` | Одиночный файл изображения.                                                                                   |
| URL             | `'https://ultralytics.com/images/bus.jpg'` | `str`            | URL на изображение.                                                                                           |
| скриншот        | `'screen'`                                 | `str`            | Снять скриншот.                                                                                               |
| PIL             | `Image.open('im.jpg')`                     | `PIL.Image`      | Формат HWC с RGB каналами.                                                                                    |
| OpenCV          | `cv2.imread('im.jpg')`                     | `np.ndarray`     | Формат HWC с BGR каналами `uint8 (0-255)`.                                                                    |
| numpy           | `np.zeros((640,1280,3))`                   | `np.ndarray`     | Формат HWC с BGR каналами `uint8 (0-255)`.                                                                    |
| torch           | `torch.zeros(16,3,320,640)`                | `torch.Tensor`   | Формат BCHW с RGB каналами `float32 (0.0-1.0)`.                                                               |
| CSV             | `'sources.csv'`                            | `str` или `Path` | CSV-файл, содержащий пути к изображениям, видео или каталогам.                                                |
| видео ✅         | `'video.mp4'`                              | `str` или `Path` | Видеофайл в форматах, вроде MP4, AVI и т.д.                                                                   |
| каталог ✅       | `'path/'`                                  | `str` или `Path` | Путь к каталогу, содержащему изображения или видео.                                                           |
| глоб ✅          | `'path/*.jpg'`                             | `str`            | Шаблон глоба для сопоставления нескольких файлов. Используйте символ `*` как подстановочный.                  |
| YouTube ✅       | `'https://youtu.be/LNwODJXcvt4'`           | `str`            | URL на видео YouTube.                                                                                         |
| поток ✅         | `'rtsp://example.com/media.mp4'`           | `str`            | URL для потоковых протоколов, таких как RTSP, RTMP, TCP, или IP-адрес.                                        |
| много-потоков ✅ | `'list.streams'`                           | `str` или `Path` | Текстовый файл `*.streams` с одним URL потока на строку, например, 8 потоков запустятся с пакетом размером 8. |

Ниже приведены примеры кода для использования каждого типа источника:

!!! Example "Источники предсказаний"

    === "изображение"
        Выполнить вывод на файл изображения.
        ```python
        from ultralytics import YOLO

        # Загрузка предварительно обученной модели YOLOv8n
        model = YOLO('yolov8n.pt')

        # Определите путь к файлу изображения
        source = 'path/to/image.jpg'

        # Выполнить вывод на источник
        results = model(source)  # список объектов Results
        ```

    === "скриншот"
        Выполнить вывод на текущее содержимое экрана в виде скриншота.
        ```python
        from ultralytics import YOLO

        # Загрузка предварительно обученной модели YOLOv8n
        model = YOLO('yolov8n.pt')

        # Определение текущего скриншота как источника
        source = 'screen'

        # Выполнить вывод на источник
        results = model(source)  # список объектов Results
        ```

    === "URL"
        Выполнить вывод на изображение или видео, размещенные удаленно по URL.
        ```python
        from ultralytics import YOLO

        # Загрузка предварительно обученной модели YOLOv8n
        model = YOLO('yolov8n.pt')

        # Определение URL удаленного изображения или видео
        source = 'https://ultralytics.com/images/bus.jpg'

        # Выполнить вывод на источник
        results = model(source)  # список объектов Results
        ```

    === "PIL"
        Выполнение вывода на изображение, открытое с помощью Python Imaging Library (PIL).
        ```python
        from PIL import Image
        from ultralytics import YOLO

        # Загрузка предварительно обученной модели YOLOv8n
        model = YOLO('yolov8n.pt')

        # Открытие изображения с помощью PIL
        source = Image.open('path/to/image.jpg')

        # Выполнение вывода на источник
        results = model(source)  # список объектов Results
        ```

    === "OpenCV"
        Выполнение вывода на изображение, прочитанное с помощью OpenCV.
        ```python
        import cv2
        from ultralytics import YOLO

        # Загрузка предварительно обученной модели YOLOv8n
        model = YOLO('yolov8n.pt')

        # Чтение изображения с помощью OpenCV
        source = cv2.imread('path/to/image.jpg')

        # Выполнение вывода на источник
        results = model(source)  # список объектов Results
        ```

    === "numpy"
        Выполнение вывода на изображение, представленное в виде массива numpy.
        ```python
        import numpy as np
        from ultralytics import YOLO

        # Загрузка предварительно обученной модели YOLOv8n
        model = YOLO('yolov8n.pt')

        # Создание случайного массива numpy с формой HWC (640, 640, 3) со значениями в диапазоне [0, 255] и типом uint8
        source = np.random.randint(low=0, high=255, size=(640, 640, 3), dtype='uint8')

        # Выполнение вывода на источник
        results = model(source)  # список объектов Results
        ```

    === "torch"
        Выполнение вывода на изображение, представленное в виде тензора PyTorch.
        ```python
        import torch
        from ultralytics import YOLO

        # Загрузка предварительно обученной модели YOLOv8n
        model = YOLO('yolov8n.pt')

        # Создание случайного тензора torch с формой BCHW (1, 3, 640, 640) со значениями в диапазоне [0, 1] и типом float32
        source = torch.rand(1, 3, 640, 640, dtype=torch.float32)

        # Выполнение вывода на источник
        results = model(source)  # список объектов Results
